'''
#Nom du programme : VanDerWaals

#Auteurs : François Lévrier, Emmanuel Baudin, Arnaud Raoux et la prépa agreg de Montrouge
#Adresse : Departement de physique de l'Ecole Normale Superieure
#		24 rue Lhomond
#		75005 Paris
#Contact : arnaud.raoux@ens.fr
#
#Année de création : 2016 
#Version : 1.20

#Liste des modifications
#v 1.00 : 2016-05-02 Première version complète
#v 1.10 : 2016-05-02 Mise à jour de la mise en page
#v 1.20 : 2019-01-09 Remplacement de axisbg dépréciée par facecolor

#Version de Python
#3.6

#LICENCE
#Cette oeuvre, création, site ou texte est sous licence Creative Commons Attribution - Pas d'Utilisation Commerciale 4.0 International. Pour accéder à une copie de cette licence, merci de vous rendre à l'adresse suivante http://creativecommons.org/licenses/by-nc/4.0/ ou envoyez un courrier à Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

#Description : 
#Ce programme représente le diagramme PV en unités réduite d'un fluide respectant l'équation d'état de Van der Waals. les références de température, pression et volume sont prises au point critique. Le diagramme trace les courbes isothermes ains que les courbes spinodales et courbes de saturation. 
'''

#import des bibliothèques python
import math
import numpy as np
import scipy
import scipy.integrate
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider, Button, RadioButtons, CheckButtons
from matplotlib import animation

# On charge les tableaux precalcules qui contiennent les donnees pour la courbe spinodale et la courbe de saturation
v_spin=[
0.666740777028,
0.667533928261,
0.668330877052,
0.669131664561,
0.669936332642,
0.670744923866,
0.671557481537,
0.672374049707,
0.673194673196,
0.674019397609,
0.674848269357,
0.675681335675,
0.676518644644,
0.677360245211,
0.67820618721,
0.679056521385,
0.679911299414,
0.680770573932,
0.681634398554,
0.682502827904,
0.683375917637,
0.68425372447,
0.685136306208,
0.686023721773,
0.686916031235,
0.687813295841,
0.688715578051,
0.689622941566,
0.690535451368,
0.691453173749,
0.692376176356,
0.693304528223,
0.694238299811,
0.695177563053,
0.696122391395,
0.697072859836,
0.698029044982,
0.698991025085,
0.699958880099,
0.700932691728,
0.70191254348,
0.702898520723,
0.703890710742,
0.704889202801,
0.7058940882,
0.706905460346,
0.707923414819,
0.708948049438,
0.70997946434,
0.711017762055,
0.712063047581,
0.713115428475,
0.714175014932,
0.71524191988,
0.716316259075,
0.717398151193,
0.718487717944,
0.719585084169,
0.72069037796,
0.721803730775,
0.722925277559,
0.724055156882,
0.725193511063,
0.726340486321,
0.727496232921,
0.728660905329,
0.729834662378,
0.731017667441,
0.732210088611,
0.733412098891,
0.734623876398,
0.73584560457,
0.737077472393,
0.738319674632,
0.739572412081,
0.740835891823,
0.742110327505,
0.743395939633,
0.744692955875,
0.746001611394,
0.747322149188,
0.748654820459,
0.749999885,
0.751357611609,
0.752728278527,
0.7541121739,
0.755509596281,
0.756920855152,
0.758346271489,
0.759786178361,
0.761240921572,
0.762710860344,
0.764196368052,
0.765697833005,
0.767215659294,
0.768750267687,
0.770302096605,
0.771871603163,
0.773459264297,
0.775065577972,
0.776691064496,
0.77833626793,
0.780001757624,
0.781688129878,
0.783396009742,
0.785126052981,
0.786878948207,
0.788655419215,
0.790456227523,
0.792282175161,
0.794134107732,
0.796012917765,
0.797919548417,
0.799854997552,
0.801820322255,
0.80381664383,
0.805845153356,
0.807907117872,
0.81000388729,
0.812136902124,
0.814307702179,
0.816517936337,
0.818769373608,
0.82106391567,
0.823403611134,
0.825790671836,
0.828227491528,
0.830716667404,
0.833261025008,
0.835863647196,
0.83852790799,
0.841257512364,
0.844056543301,
0.84692951779,
0.849881453938,
0.852917952033,
0.856045293234,
0.859270560846,
0.862601790806,
0.866048160482,
0.869620228388,
0.873330242695,
0.877192544293,
0.881224102389,
0.88544524014,
0.889880639787,
0.894560771236,
0.899523984828,
0.904819689621,
0.910513396177,
0.916695164481,
0.923494774181,
0.931111599884,
0.939881587196,
0.950460421036,
0.964542594066,
0.999634962704,
1.00036525952,
1.03768432025,
1.05399768524,
1.06681222449,
1.0778224443,
1.08768404328,
1.09673298079,
1.10516864524,
1.11312083013,
1.12067960937,
1.12791050749,
1.13486294757,
1.14157529404,
1.14807803096,
1.15439585475,
1.16054910285,
1.16655475876,
1.17242717775,
1.17817862243,
1.18381966581,
1.18935949979,
1.19480617494,
1.20016678922,
1.20544763853,
1.21065433794,
1.21579192041,
1.22086491785,
1.22587742821,
1.23083317151,
1.23573553686,
1.24058762228,
1.24539226853,
1.25015208811,
1.2548694901,
1.25954670177,
1.26418578719,
1.26878866359,
1.27335711559,
1.27789280774,
1.28239729557,
1.28687203541,
1.29131839304,
1.29573765144,
1.30013101767,
1.30449962912,
1.30884455901,
1.3131668214,
1.31746737573,
1.32174713086,
1.32600694881,
1.33024764808,
1.33447000675,
1.33867476522,
1.3428626288,
1.34703427001,
1.35119033073,
1.35533142417,
1.35945813664,
1.36357102926,
1.36767063945,
1.37175748236,
1.37583205221,
1.37989482344,
1.38394625188,
1.3879867758,
1.39201681684,
1.39603678095,
1.40004705923,
1.40404802868,
1.40804005297,
1.41202348312,
1.41599865812,
1.41996590555,
1.42392554215,
1.42787787431,
1.43182319861,
1.43576180226,
1.43969396356,
1.44361995227,
1.44754003004,
1.45145445079,
1.45536346099,
1.45926730006,
1.46316620061,
1.46706038881,
1.47095008459,
1.47483550195,
1.4787168492,
1.48259432918,
1.4864681395,
1.49033847272,
1.49420551661,
1.49806945428,
1.5019304644,
1.50578872136,
1.50964439544,
1.51349765296,
1.51734865641,
1.52119756465,
1.52504453299,
1.52888971336,
1.53273325438,
1.53657530155,
1.54041599731,
1.54425548116,
1.54809388978,
1.5519313571,
1.55576801444,
1.55960399055,
1.56343941173,
1.56727440191,
1.5711090827,
1.57494357353,
1.57877799165,
1.58261245225,
1.58644706851,
1.59028195169,
1.59411721115,
1.59795295443,
1.60178928733,
1.60562631394,
1.60946413669,
1.61330285642,
1.61714257244,
1.62098338254,
1.62482538306,
1.62866866894,
1.63251333375,
1.63635946975,
1.64020716791,
1.64405651794,
1.64790760837,
1.65176052655,
1.65561535869,
1.65947218991,
1.66333110426,
1.66719218475,
1.67105551338,
1.67492117118,
1.67878923824,
1.68265979371,
1.68653291588,
1.69040868214,
1.69428716906,
1.69816845239,
1.70205260707,
1.70593970729,
1.7098298265,
1.71372303739,
1.71761941198,
1.72151902159,
1.72542193687,
1.72932822783,
1.73323796387,
1.73715121376,
1.74106804568,
1.74498852725,
1.74891272552,
1.75284070701,
1.7567725377,
1.76070828309,
1.76464800815,
1.76859177739,
1.77253965486,
1.77649170414,
1.78044798838,
1.78440857031,
1.78837351224,
1.79234287609,
1.79631672337,
1.80029511525,
1.8042781125,
1.80826577556,
1.81225816451,
1.81625533912,
1.82025735881,
1.82426428273,
1.8282761697,
1.83229307824,
1.83631506662,
1.84034219283,
1.84437451457,
1.84841208931,
1.85245497429,
1.85650322647,
1.86055690263,
1.86461605929,
1.86868075279,
1.87275103924,
1.87682697457,
1.88090861452,
1.88499601464,
1.88908923031,
1.89318831675,
1.89729332901,
1.901404322,
1.90552135047,
1.90964446904,
1.91377373218,
1.91790919425,
1.92205090949,
1.92619893202,
1.93035331584,
1.93451411487,
1.93868138292,
1.9428551737,
1.94703554085,
1.95122253792,
1.9554162184,
1.9596166357,
1.96382384315,
1.96803789405,
1.97225884163,
1.97648673908,
1.98072163953,
1.98496359609,
1.98921266182,
1.99346888976,
1.99773233292,
2.00200304431,
2.00628107688,
2.01056648362,
2.01485931747,
2.01915963139,
2.02346747835,
2.02778291131,
2.03210598324,
2.03643674712,
2.04077525598,
2.04512156284,
2.04947572075,
2.0538377828,
2.05820780212,
2.06258583186,
2.06697192523,
2.07136613548,
2.0757685159,
2.08017911985,
2.08459800074,
2.08902521203,
2.09346080726,
2.09790484004,
2.10235736403,
2.10681843299,
2.11128810074,
2.1157664212,
2.12025344836,
2.12474923631,
2.12925383921,
2.13376731136,
2.13828970711,
2.14282108095,
2.14736148745,
2.1519109813,
2.15646961731,
2.1610374504,
2.16561453559,
2.17020092805,
2.17479668307,
2.17940185604,
2.18401650253,
2.18864067821,
2.19327443889,
2.19791784053,
2.20257093923,
2.20723379125,
2.21190645298,
2.21658898098,
2.22128143195,
2.22598386277,
2.23069633046,
2.23541889223,
2.24015160543,
2.24489452762,
2.24964771649,
2.25441122995,
2.25918512607,
2.26396946309,
2.26876429947,
2.27356969383,
2.27838570501,
2.28321239201,
2.28804981407,
2.29289803061,
2.29775710125,
2.30262708582,
2.30750804439,
2.31240003719,
2.31730312472,
2.32221736768,
2.32714282697,
2.33207956375,
2.33702763939,
2.34198711551,
2.34695805394,
2.35194051677,
2.35693456631,
2.36194026514,
2.36695767607,
2.37198686215,
2.37702788672,
2.38208081335,
2.38714570585,
2.39222262835,
2.39731164519,
2.402412821,
2.40752622069,
2.41265190944,
2.4177899527,
2.42294041622,
2.428103366,
2.43327886836,
2.43846698991,
2.44366779753,
2.44888135841,
2.45410774006,
2.45934701026,
2.46459923711,
2.46986448904,
2.47514283476,
2.48043434331,
2.48573908407,
2.49105712671,
2.49638854125,
2.50173339804,
2.50709176774,
2.51246372137,
2.51784933028,
2.52324866617,
2.52866180109,
2.53408880742,
2.53952975791,
2.54498472568,
2.55045378418,
2.55593700725,
2.56143446909,
2.56694624425,
2.57247240771,
2.57801303476,
2.58356820113,
2.5891379829,
2.59472245656,
2.60032169899,
2.60593578745,
2.61156479963,
2.61720881359,
2.62286790784,
2.62854216127,
2.63423165319,
2.63993646335,
2.6456566719,
2.65139235944,
2.65714360698,
2.66291049599,
2.66869310836,
2.67449152643,
2.68030583299,
2.68613611129,
2.69198244503,
2.69784491835,
2.7037236159,
2.70961862275,
2.71553002449,
2.72145790715,
2.72740235726,
2.73336346183,
2.73934130838,
2.74533598489,
2.75134757986,
2.75737618231,
2.76342188175,
2.76948476819,
2.77556493218,
2.7816624648,
2.78777745763,
2.79391000281,
2.80006019299,
2.80622812138,
2.81241388174,
2.81861756837,
2.82483927612,
2.83107910042,
2.83733713726,
2.8436134832,
2.84990823538,
2.85622149151,
2.8625533499,
2.86890390945,
2.87527326966,
2.88166153062,
2.88806879304,
2.89449515825,
2.90094072818,
2.9074056054,
2.91388989311,
2.92039369514,
2.92691711596,
2.93346026069,
2.94002323512,
2.94660614567,
2.95320909944,
2.95983220421,
2.96647556843,
2.97313930122,
2.9798235124,
2.9865283125,
2.99325381272,
3.000000125,
3.00676736197,
3.013555637,
3.02036506417,
3.02719575831,
3.03404783498,
3.04092141049,
3.0478166019,
3.05473352704,
3.06167230449,
3.06863305364,
3.07561589461,
3.08262094836,
3.08964833661,
3.0966981819,
3.10377060758,
3.1108657378,
3.11798369756,
3.12512461268,
3.13228860982,
3.13947581648,
3.14668636103,
3.15392037271,
3.1611779816,
3.16845931868,
3.17576451583,
3.1830937058,
3.19044702226,
3.19782459977,
3.20522657385,
3.21265308091,
3.22010425832,
3.22758024438,
3.23508117836,
3.24260720049,
3.25015845196,
3.25773507496,
3.26533721265,
3.27296500922,
3.28061860983,
3.28829816069,
3.29600380902,
3.30373570309,
3.31149399222,
3.31927882676,
3.32709035816,
3.33492873893,
3.34279412268,
3.35068666409,
3.35860651897,
3.36655384426,
3.37452879799,
3.38253153937,
3.39056222874,
3.3986210276,
3.40670809863,
3.41482360569,
3.42296771383,
3.43114058931,
3.43934239963,
3.44757331347,
3.45583350079,
3.46412313281,
3.47244238197,
3.48079142203,
3.48917042803,
3.4975795763,
3.50601904449,
3.51448901158,
3.5229896579,
3.53152116512,
3.54008371628,
3.5486774958,
3.55730268949,
3.56595948458,
3.57464806971,
3.58336863496,
3.59212137186,
3.60090647339,
3.60972413402,
3.61857454972,
3.62745791795,
3.63637443771,
3.64532430952,
3.65430773546,
3.66332491919,
3.67237606593,
3.68146138253,
3.69058107742,
3.6997353607,
3.70892444408,
3.71814854097,
3.72740786644,
3.73670263727,
3.74603307195,
3.7553993907,
3.76480181551,
3.77424057012,
3.78371588007,
3.79322797268,
3.80277707714,
3.81236342444,
3.82198724746,
3.83164878094,
3.84134826153,
3.8510859278,
3.86086202027,
3.8706767814,
3.88053045565,
3.89042328947,
3.90035553132,
3.91032743174,
3.92033924331,
3.93039122069,
3.94048362065,
3.95061670212,
3.96079072616,
3.97100595599,
3.98126265706,
3.99156109703,
4.00190154581,
4.01228427557,
4.02270956078,
4.03317767824,
4.04368890708,
4.0542435288,
4.06484182731,
4.07548408892,
4.0861706024,
4.09690165899,
4.10767755243,
4.11849857899,
4.1293650375,
4.14027722937,
4.15123545861,
4.16224003188,
4.17329125852,
4.18438945054,
4.19553492272,
4.20672799257,
4.21796898038,
4.2292582093,
4.24059600529,
4.25198269723,
4.26341861688,
4.27490409899,
4.28643948126,
4.29802510443,
4.30966131226,
4.32134845162,
4.33308687249,
4.34487692802,
4.35671897452,
4.36861337156,
4.38056048195,
4.39256067182,
4.40461431064,
4.41672177123,
4.42888342987,
4.44109966627,
4.45337086364,
4.46569740873,
4.47807969187,
4.49051810702,
4.50301305179,
4.51556492751,
4.52817413924,
4.54084109585,
4.55356621005,
4.56634989842,
4.5791925815,
4.59209468377,
4.60505663376,
4.61807886407,
4.63116181141,
4.64430591669,
4.657511625,
4.67077938574,
4.68410965261,
4.69750288371,
4.71095954155,
4.72448009312,
4.73806500998,
4.75171476825,
4.76542984873,
4.77921073689,
4.79305792302,
4.80697190218,
4.82095317436,
4.83500224446,
4.84911962242,
4.86330582322,
4.87756136699,
4.89188677906,
4.90628259001,
4.92074933577,
4.93528755764,
4.94989780241,
4.96458062239,
4.9793365755,
4.99416622534,
5.00907014126,
5.02404889843,
5.03910307791,
5.05423326674,
5.06944005803,
5.08472405099,
5.10008585107,
5.11552606999,
5.13104532584,
5.14664424319,
5.16232345312,
5.17808359337,
5.19392530838,
5.20984924938,
5.22585607452,
5.24194644892,
5.25812104478,
5.27438054149,
5.29072562568,
5.30715699138,
5.32367534007,
5.34028138081,
5.35697583031,
5.37375941307,
5.39063286148,
5.4075969159,
5.42465232481,
5.44179984488,
5.45904024111,
5.47637428695,
5.49380276438,
5.51132646409,
5.52894618553,
5.54666273708,
5.56447693618,
5.58238960942,
5.60040159268,
5.61851373131,
5.63672688019,
5.6550419039,
5.67345967688,
5.69198108354,
5.7106070184,
5.72933838627,
5.74817610235,
5.76712109244,
5.78617429302,
5.80533665148,
5.82460912622,
5.84399268684,
5.86348831432,
5.88309700115,
5.9028197515,
5.92265758144,
5.94261151908,
5.96268260475,
5.98287189117,
6.00318044369,
6.02360934043,
6.04415967246,
6.06483254405,
6.08562907284,
6.10655039004,
6.12759764063,
6.14877198359,
6.17007459213,
6.19150665385,
6.21306937102,
6.23476396077,
6.25659165535,
6.27855370236,
6.30065136495,
6.32288592212,
6.34525866895,
6.36777091683,
6.39042399374,
6.41321924452,
6.43615803112,
6.45924173289,
6.48247174684,
6.50584948795,
6.52937638942,
6.55305390302,
6.57688349934,
6.60086666813,
6.62500491858,
6.64929977969,
6.67375280053,
6.69836555066,
6.72313962035,
6.74807662104,
6.77317818563,
6.79844596883,
6.82388164758,
6.84948692138,
6.87526351268,
6.90121316727,
6.92733765468,
6.9536387686,
6.98011832726,
7.00677817388,
7.03362017709,
7.06064623137,
7.08785825749,
7.11525820299,
7.14284804264,
7.17062977889,
7.19860544242,
7.22677709255,
7.25514681784,
7.28371673655,
7.31248899719,
7.34146577906,
7.37064929281,
7.40004178098,
7.42964551863,
7.45946281388,
7.48949600853,
7.51974747869,
7.55021963539,
7.58091492525,
7.61183583111,
7.64298487273,
7.67436460744,
7.7059776309,
7.73782657778,
7.7699141225,
7.80224298,
7.83481590648,
7.86763570023,
7.9007052024,
7.93402729785,
7.96760491596,
8.00144103153,
8.03553866566,
8.06990088662,
8.1045308108,
8.13943160367,
8.17460648072,
8.21005870847,
8.2457916055,
8.28180854345,
8.31811294813,
8.35470830058,
8.39159813821,
8.42878605594,
8.46627570736,
8.50407080594,
8.54217512627,
8.58059250534,
8.61932684377,
8.65838210722,
8.69776232767,
8.73747160489,
8.7775141078,
8.81789407599,
8.85861582119,
8.89968372883,
8.9411022596,
8.9828759511,
9.02500941949,
9.0675073612,
9.11037455468,
9.15361586219,
9.19723623166,
9.24124069861,
9.28563438802,
9.33042251642,
9.37561039387,
9.4212034261,
9.46720711669,
9.51362706924,
9.5604689897,
9.60773868872,
9.65544208403,
9.70358520294,
9.75217418488,
9.80121528402,
9.85071487199,
9.90067944061,
9.95111560475,
10.0020301053,
10.053429812,
10.105321727,
10.1577129875,
10.2106108692,
10.26402279,
10.3179563131,
10.3724191508,
10.4274191679,
10.482964386,
10.5390629868,
10.5957233168,
10.6529538907,
10.7107633965,
10.7691606991,
10.8281548456,
10.8877550693,
10.947970795,
11.0088116438,
11.0702874384,
11.1324082082,
11.1951841947,
11.2586258576,
11.32274388,
11.387549175,
11.4530528915,
11.5192664207,
11.586201403,
11.6538697344,
11.7222835739,
11.7914553506,
11.8613977715,
11.9321238289,
12.0036468088,
12.0759802994,
12.149138199,
12.2231347257,
12.2979844262,
12.3737021857,
12.4503032373,
12.5278031727,
12.6062179525,
12.6855639173,
12.7658577993,
12.8471167336,
12.9293582708,
13.0126003895,
13.0968615096,
13.1821605057,
13.2685167214,
13.3559499837,
13.4444806185,
13.5341294664,
13.6249178987,
13.7168678349,
13.8100017599,
13.9043427429,
13.999914456,
14.0967411942,
14.1948478963,
14.2942601659,
14.395004294,
14.4971072822,
14.6005968668,
14.7055015439,
14.8118505959,
14.9196741182,
15.0290030485,
15.1398691956,
15.2523052709,
15.3663449202,
15.4820227575,
15.5993744004,
15.7184365061,
15.8392468101,
15.9618441658,
16.0862685867,
16.2125612893,
16.3407647394,
16.4709226993,
16.6030802778,
16.7372839825,
16.8735817744,
17.0120231248,
17.1526590757,
17.2955423025,
17.4407271796,
17.5882698497,
17.7382282964,
17.89066242,
18.0456341173,
18.2032073658,
18.3634483117,
18.5264253627,
18.6922092851,
18.8608733069,
19.0324932253,
19.2071475206,
19.3849174761,
19.5658873039,
19.7501442788,
19.9377788778,
20.1288849293,
20.323559769,
20.5219044059,
20.7240236967,
20.9300265311,
21.1400260277,
21.3541397407,
21.5724898803,
21.7952035449,
22.0224129681,
22.2542557808,
22.4908752897,
22.732420772,
22.9790477907,
23.2309185284,
23.4882021431,
23.7510751475,
24.0197218133,
24.2943346019,
24.5751146244,
24.8622721337,
25.1560270491,
25.4566095188,
25.7642605217,
26.0792325115,
26.4017901086,
26.7322108413,
27.0707859435,
27.4178212103,
27.7736379203,
28.1385738278,
28.5129842327,
28.8972431349,
29.291744481,
29.6969035119,
30.1131582212,
30.5409709357,
30.9808300286,
31.4332517801,
31.8987823995,
32.3780002262,
32.8715181271,
33.3799861125,
33.9040941933,
34.444575506,
35.0022097353,
35.577826868,
36.1723113163,
36.7866064529,
37.4217196079,
38.0787275825,
38.7587827425,
39.4631197654,
40.1930631233,
40.9500353971,
41.7355665322,
42.5513041617,
43.3990251446,
44.2806484883,
45.1982498534,
46.1540778722,
47.150572549,
48.1903860625,
49.2764063394,
50.4117838452,
51.5999621108,
52.8447126219,
54.1501748127,
55.5209020603,
56.9619147533,
58.4787617407,
60.0775917457,
61.7652366809,
63.5493092466,
65.4383177523,
67.4418018147,
69.5704934986,
71.836509647,
74.2535826764,
76.8373391233,
79.6056378786,
82.5789835848,
85.7810354326,
89.2392380683,
92.9856102265,
97.0577390934,
101.500045858,
106.365412847,
111.717298802,
117.632522125,
124.204971884,
131.55062856,
139.814467573,
149.180124198,
159.883700557,
172.23394502,
186.642521224,
203.670787315,
224.104642452,
249.079270434,
280.297439871,
320.43491612,
373.951278411,
448.873698075,
561.2563173,
748.558088414,
1123.15212643,
2246.85910661,
22499999.3333]

p_spin=[
0.000750117222683,
0.00874684310783,
0.0167245678349,
0.0246832908869,
0.0326230114181,
0.0405437282492,
0.0484454398637,
0.0563281444036,
0.0641918396646,
0.0720365230922,
0.0798621917766,
0.0876688424482,
0.0954564714726,
0.103225074846,
0.110974648189,
0.118705186744,
0.126416685365,
0.134109138517,
0.141782540269,
0.149436884286,
0.157072163824,
0.164688371726,
0.172285500413,
0.179863541878,
0.187422487681,
0.19496232894,
0.202483056326,
0.209984660052,
0.21746712987,
0.224930455061,
0.232374624427,
0.239799626285,
0.247205448454,
0.254592078252,
0.261959502482,
0.269307707426,
0.276636678836,
0.283946401921,
0.29123686134,
0.298508041192,
0.305759925001,
0.31299249571,
0.320205735667,
0.327399626616,
0.334574149679,
0.341729285352,
0.348865013483,
0.355981313267,
0.363078163227,
0.370155541202,
0.377213424331,
0.38425178904,
0.391270611024,
0.398269865232,
0.405249525849,
0.412209566282,
0.419149959137,
0.426070676205,
0.432971688441,
0.439852965942,
0.446714477929,
0.453556192725,
0.460378077732,
0.467180099407,
0.473962223241,
0.480724413731,
0.487466634355,
0.494188847545,
0.500891014661,
0.507573095958,
0.514235050559,
0.52087683642,
0.527498410301,
0.53409972773,
0.540680742966,
0.547241408963,
0.553781677329,
0.560301498291,
0.566800820644,
0.573279591714,
0.579737757308,
0.586175261665,
0.592592047407,
0.598988055485,
0.60536322512,
0.611717493751,
0.618050796967,
0.624363068444,
0.630654239882,
0.636924240923,
0.643172999088,
0.649400439687,
0.655606485744,
0.661791057901,
0.667954074333,
0.674095450641,
0.680215099755,
0.686312931822,
0.692388854086,
0.698442770768,
0.704474582933,
0.71048418835,
0.716471481346,
0.722436352644,
0.728378689196,
0.734298374003,
0.740195285924,
0.746069299467,
0.75192028457,
0.757748106364,
0.763552624919,
0.76933369497,
0.775091165621,
0.780824880026,
0.786534675047,
0.792220380878,
0.797881820641,
0.803518809945,
0.809131156407,
0.814718659126,
0.820281108112,
0.825818283652,
0.831329955625,
0.83681588273,
0.842275811649,
0.847709476107,
0.853116595833,
0.858496875395,
0.8638500029,
0.869175648529,
0.874473462883,
0.879743075111,
0.884984090769,
0.890196089381,
0.895378621621,
0.900531206052,
0.905653325328,
0.910744421735,
0.915803891919,
0.920831080591,
0.925825272962,
0.930785685522,
0.935711454706,
0.940601622752,
0.9454551198,
0.950270740837,
0.955047115417,
0.959782666939,
0.964475556348,
0.969123601654,
0.973724157944,
0.978273928825,
0.982768648562,
0.987202491527,
0.991566801839,
0.995846565356,
0.999999599854,
0.999999600146,
0.996139280512,
0.992394985994,
0.98872451846,
0.985112847818,
0.981551302198,
0.978034039943,
0.974556779249,
0.971116207612,
0.967709663971,
0.964334950143,
0.960990210844,
0.9576738532,
0.95438449045,
0.951120901229,
0.947881999279,
0.944666810401,
0.941474454551,
0.9383041317,
0.935155110493,
0.932026719039,
0.928918337335,
0.925829390979,
0.922759345892,
0.919707703864,
0.91667399875,
0.913657793213,
0.910658675907,
0.907676259034,
0.904710176203,
0.901760080563,
0.898825643142,
0.895906551387,
0.893002507861,
0.890113229079,
0.887238444469,
0.884377895431,
0.8815313345,
0.878698524574,
0.875879238231,
0.873073257089,
0.870280371242,
0.86750037873,
0.864733085058,
0.861978302761,
0.85923585099,
0.856505555149,
0.85378724654,
0.851080762052,
0.848385943861,
0.845702639159,
0.843030699895,
0.840369982546,
0.837720347885,
0.835081660786,
0.832453790023,
0.829836608095,
0.827229991054,
0.824633818348,
0.822047972671,
0.819472339827,
0.816906808592,
0.814351270595,
0.8118056202,
0.809269754396,
0.806743572689,
0.80422697701,
0.801719871616,
0.799222163005,
0.796733759829,
0.794254572818,
0.791784514705,
0.789323500147,
0.786871445668,
0.784428269585,
0.781993891949,
0.779568234489,
0.777151220552,
0.77474277505,
0.772342824413,
0.769951296533,
0.767568120724,
0.765193227674,
0.762826549403,
0.760468019222,
0.758117571692,
0.755775142592,
0.753440668877,
0.751114088646,
0.748795341109,
0.746484366555,
0.744181106322,
0.741885502765,
0.73959749923,
0.737317040029,
0.735044070409,
0.732778536529,
0.730520385437,
0.728269565046,
0.726026024109,
0.723789712201,
0.721560579696,
0.719338577747,
0.717123658266,
0.714915773907,
0.712714878046,
0.710520924764,
0.70833386883,
0.706153665685,
0.703980271425,
0.701813642786,
0.699653737132,
0.697500512435,
0.695353927264,
0.693213940775,
0.691080512692,
0.688953603295,
0.686833173413,
0.684719184407,
0.68261159816,
0.680510377066,
0.678415484018,
0.676326882398,
0.67424453607,
0.672168409364,
0.670098467069,
0.668034674427,
0.665976997119,
0.663925401256,
0.661879853376,
0.659840320429,
0.657806769773,
0.655779169164,
0.653757486749,
0.65174169106,
0.649731751002,
0.647727635853,
0.645729315248,
0.643736759182,
0.641749937996,
0.639768822373,
0.637793383334,
0.635823592227,
0.633859420726,
0.631900840821,
0.629947824817,
0.628000345323,
0.626058375253,
0.624121887812,
0.622190856501,
0.620265255104,
0.618345057687,
0.616430238592,
0.614520772434,
0.612616634093,
0.610717798713,
0.608824241696,
0.606935938697,
0.605052865623,
0.603174998625,
0.601302314096,
0.599434788668,
0.597572399205,
0.595715122803,
0.593862936786,
0.592015818698,
0.590173746305,
0.588336697588,
0.586504650743,
0.584677584174,
0.582855476491,
0.581038306509,
0.579226053243,
0.577418695904,
0.575616213899,
0.573818586825,
0.57202579447,
0.570237816806,
0.568454633988,
0.566676226352,
0.564902574413,
0.563133658861,
0.561369460558,
0.559609960537,
0.557855139999,
0.556104980311,
0.554359463003,
0.552618569766,
0.550882282452,
0.549150583066,
0.54742345377,
0.545700876879,
0.543982834857,
0.542269310316,
0.540560286017,
0.538855744862,
0.537155669899,
0.535460044313,
0.533768851433,
0.532082074719,
0.53039969777,
0.528721704318,
0.527048078226,
0.525378803489,
0.523713864227,
0.522053244689,
0.52039692925,
0.518744902407,
0.51709714878,
0.51545365311,
0.513814400255,
0.512179375192,
0.510548563016,
0.508921948933,
0.507299518266,
0.505681256447,
0.50406714902,
0.50245718164,
0.500851340066,
0.499249610168,
0.497651977919,
0.496058429396,
0.49446895078,
0.492883528354,
0.491302148502,
0.489724797705,
0.488151462545,
0.486582129701,
0.485016785945,
0.483455418149,
0.481898013274,
0.480344558377,
0.478795040605,
0.477249447199,
0.475707765485,
0.474169982881,
0.472636086892,
0.471106065111,
0.469579905214,
0.468057594965,
0.46653912221,
0.465024474879,
0.463513640984,
0.462006608619,
0.460503365958,
0.459003901254,
0.457508202839,
0.456016259124,
0.454528058596,
0.45304358982,
0.451562841433,
0.45008580215,
0.44861246076,
0.447142806123,
0.445676827173,
0.444214512915,
0.442755852426,
0.441300834852,
0.439849449409,
0.438401685382,
0.436957532125,
0.435516979057,
0.434080015667,
0.432646631508,
0.431216816199,
0.429790559424,
0.428367850931,
0.426948680531,
0.425533038099,
0.424120913573,
0.422712296951,
0.421307178293,
0.419905547719,
0.418507395409,
0.417112711605,
0.415721486603,
0.414333710762,
0.412949374495,
0.411568468276,
0.410190982631,
0.408816908147,
0.407446235464,
0.406078955276,
0.404715058334,
0.403354535442,
0.401997377458,
0.400643575292,
0.399293119908,
0.397946002322,
0.3966022136,
0.39526174486,
0.393924587273,
0.392590732058,
0.391260170483,
0.389932893867,
0.388608893578,
0.387288161033,
0.385970687695,
0.384656465076,
0.383345484735,
0.382037738279,
0.380733217359,
0.379431913674,
0.378133818969,
0.376838925032,
0.375547223698,
0.374258706846,
0.372973366397,
0.371691194319,
0.370412182622,
0.369136323357,
0.367863608621,
0.366594030551,
0.365327581327,
0.36406425317,
0.362804038341,
0.361546929145,
0.360292917925,
0.359041997065,
0.357794158989,
0.356549396159,
0.355307701079,
0.354069066289,
0.352833484371,
0.351600947941,
0.350371449657,
0.349144982212,
0.347921538338,
0.346701110802,
0.34548369241,
0.344269276003,
0.343057854459,
0.341849420692,
0.34064396765,
0.339441488319,
0.338241975717,
0.337045422899,
0.335851822954,
0.334661169005,
0.333473454208,
0.332288671756,
0.331106814871,
0.329927876812,
0.328751850869,
0.327578730364,
0.326408508654,
0.325241179125,
0.324076735198,
0.322915170323,
0.321756477984,
0.320600651695,
0.319447685,
0.318297571476,
0.317150304728,
0.316005878394,
0.31486428614,
0.313725521662,
0.312589578688,
0.311456450972,
0.3103261323,
0.309198616485,
0.30807389737,
0.306951968827,
0.305832824754,
0.30471645908,
0.303602865761,
0.30249203878,
0.301383972148,
0.300278659903,
0.299176096112,
0.298076274866,
0.296979190285,
0.295884836516,
0.29479320773,
0.293704298126,
0.292618101929,
0.29153461339,
0.290453826784,
0.289375736413,
0.288300336604,
0.28722762171,
0.286157586107,
0.285090224198,
0.284025530409,
0.282963499191,
0.281904125019,
0.280847402393,
0.279793325836,
0.278741889895,
0.277693089142,
0.27664691817,
0.275603371597,
0.274562444065,
0.273524130236,
0.272488424798,
0.27145532246,
0.270424817953,
0.269396906033,
0.268371581475,
0.267348839078,
0.266328673664,
0.265311080074,
0.264296053173,
0.263283587846,
0.262273679001,
0.261266321565,
0.260261510488,
0.259259240741,
0.258259507314,
0.25726230522,
0.256267629492,
0.255275475181,
0.254285837362,
0.253298711127,
0.252314091591,
0.251331973887,
0.250352353168,
0.249375224607,
0.248400583396,
0.247428424747,
0.246458743892,
0.24549153608,
0.244526796582,
0.243564520684,
0.242604703696,
0.241647340942,
0.240692427767,
0.239739959535,
0.238789931625,
0.237842339438,
0.236897178392,
0.235954443922,
0.235014131482,
0.234076236544,
0.233140754596,
0.232207681145,
0.231277011716,
0.230348741849,
0.229422867105,
0.228499383059,
0.227578285304,
0.22665956945,
0.225743231124,
0.22482926597,
0.223917669648,
0.223008437835,
0.222101566225,
0.221197050526,
0.220294886467,
0.219395069787,
0.218497596246,
0.217602461618,
0.216709661694,
0.215819192278,
0.214931049193,
0.214045228276,
0.21316172538,
0.212280536373,
0.211401657138,
0.210525083575,
0.209650811597,
0.208778837133,
0.207909156129,
0.207041764541,
0.206176658346,
0.20531383353,
0.204453286097,
0.203595012065,
0.202739007466,
0.201885268347,
0.201033790769,
0.200184570807,
0.199337604551,
0.198492888103,
0.197650417582,
0.19681018912,
0.19597219886,
0.195136442963,
0.194302917601,
0.193471618961,
0.192642543242,
0.191815686658,
0.190991045436,
0.190168615816,
0.189348394051,
0.188530376408,
0.187714559167,
0.18690093862,
0.186089511073,
0.185280272845,
0.184473220267,
0.183668349683,
0.18286565745,
0.182065139938,
0.181266793529,
0.180470614617,
0.179676599609,
0.178884744924,
0.178095046994,
0.177307502264,
0.176522107188,
0.175738858234,
0.174957751884,
0.174178784629,
0.173401952973,
0.172627253431,
0.171854682532,
0.171084236814,
0.170315912829,
0.169549707138,
0.168785616317,
0.16802363695,
0.167263765635,
0.16650599898,
0.165750333604,
0.164996766138,
0.164245293225,
0.163495911517,
0.162748617678,
0.162003408385,
0.161260280322,
0.160519230187,
0.159780254689,
0.159043350544,
0.158308514484,
0.157575743248,
0.156845033586,
0.15611638226,
0.155389786043,
0.154665241715,
0.15394274607,
0.153222295911,
0.15250388805,
0.151787519313,
0.151073186532,
0.150360886551,
0.149650616224,
0.148942372416,
0.148236152001,
0.147531951862,
0.146829768894,
0.146129600001,
0.145431442095,
0.144735292101,
0.144041146951,
0.143349003588,
0.142658858965,
0.141970710044,
0.141284553795,
0.140600387201,
0.139918207251,
0.139238010944,
0.138559795291,
0.13788355731,
0.137209294028,
0.136537002482,
0.135866679717,
0.135198322791,
0.134531928765,
0.133867494714,
0.13320501772,
0.132544494874,
0.131885923277,
0.131229300036,
0.13057462227,
0.129921887106,
0.129271091678,
0.128622233131,
0.127975308617,
0.127330315298,
0.126687250343,
0.126046110931,
0.125406894248,
0.12476959749,
0.124134217861,
0.123500752572,
0.122869198844,
0.122239553907,
0.121611814996,
0.120985979357,
0.120362044244,
0.119740006917,
0.119119864647,
0.118501614712,
0.117885254397,
0.117270780996,
0.11665819181,
0.11604748415,
0.115438655332,
0.114831702683,
0.114226623536,
0.113623415231,
0.113022075117,
0.112422600551,
0.111824988898,
0.111229237527,
0.11063534382,
0.110043305164,
0.109453118951,
0.108864782586,
0.108278293477,
0.107693649041,
0.107110846703,
0.106529883894,
0.105950758053,
0.105373466628,
0.104798007071,
0.104224376843,
0.103652573414,
0.103082594257,
0.102514436855,
0.101948098699,
0.101383577285,
0.100820870116,
0.100259974704,
0.0997008885656,
0.0991436092263,
0.0985881342177,
0.0980344610784,
0.0974825873538,
0.0969325105962,
0.0963842283649,
0.0958377382258,
0.0952930377516,
0.0947501245217,
0.0942089961223,
0.0936696501462,
0.0931320841928,
0.0925962958682,
0.0920622827852,
0.0915300425628,
0.090999572827,
0.0904708712099,
0.0899439353503,
0.0894187628934,
0.0888953514909,
0.0883736988007,
0.0878538024873,
0.0873356602213,
0.0868192696799,
0.0863046285463,
0.0857917345102,
0.0852805852675,
0.0847711785201,
0.0842635119763,
0.0837575833506,
0.0832533903634,
0.0827509307415,
0.0822502022175,
0.0817512025302,
0.0812539294246,
0.0807583806513,
0.0802645539672,
0.0797724471352,
0.0792820579239,
0.0787933841079,
0.0783064234679,
0.0778211737901,
0.0773376328668,
0.076855798496,
0.0763756684815,
0.075897240633,
0.0754205127658,
0.074945482701,
0.0744721482652,
0.0740005072911,
0.0735305576166,
0.0730622970856,
0.0725957235472,
0.0721308348565,
0.071667628874,
0.0712061034656,
0.070746256503,
0.0702880858631,
0.0698315894284,
0.069376765087,
0.0689236107323,
0.068472124263,
0.0680223035834,
0.0675741466031,
0.0671276512368,
0.066682815405,
0.0662396370332,
0.0657981140521,
0.0653582443979,
0.0649200260119,
0.0644834568407,
0.064048534836,
0.0636152579547,
0.0631836241591,
0.0627536314163,
0.0623252776986,
0.0618985609836,
0.0614734792538,
0.0610500304969,
0.0606282127054,
0.060208023877,
0.0597894620145,
0.0593725251254,
0.0589572112224,
0.0585435183232,
0.0581314444501,
0.0577209876306,
0.057312145897,
0.0569049172865,
0.0564992998411,
0.0560952916076,
0.0556928906378,
0.055292094988,
0.0548929027196,
0.0544953118985,
0.0540993205956,
0.0537049268862,
0.0533121288506,
0.0529209245737,
0.0525313121449,
0.0521432896586,
0.0517568552135,
0.0513720069131,
0.0509887428655,
0.0506070611833,
0.0502269599837,
0.0498484373885,
0.049471491524,
0.049096120521,
0.0487223225149,
0.0483500956454,
0.0479794380569,
0.047610347898,
0.0472428233218,
0.0468768624861,
0.0465124635527,
0.0461496246881,
0.0457883440628,
0.0454286198522,
0.0450704502355,
0.0447138333965,
0.0443587675233,
0.0440052508082,
0.0436532814479,
0.0433028576432,
0.0429539775992,
0.0426066395253,
0.0422608416351,
0.0419165821463,
0.0415738592809,
0.041232671265,
0.0408930163288,
0.0405548927068,
0.0402182986375,
0.0398832323635,
0.0395496921316,
0.0392176761925,
0.0388871828012,
0.0385582102166,
0.0382307567016,
0.0379048205232,
0.0375803999524,
0.0372574932641,
0.0369360987374,
0.0366162146552,
0.0362978393043,
0.0359809709755,
0.0356656079636,
0.0353517485672,
0.0350393910889,
0.034728533835,
0.0344191751158,
0.0341113132456,
0.0338049465422,
0.0335000733274,
0.0331966919269,
0.0328948006702,
0.0325943978903,
0.0322954819244,
0.031998051113,
0.0317021038008,
0.0314076383359,
0.0311146530703,
0.0308231463597,
0.0305331165633,
0.0302445620443,
0.0299574811693,
0.0296718723087,
0.0293877338365,
0.0291050641303,
0.0288238615714,
0.0285441245448,
0.0282658514387,
0.0279890406453,
0.0277136905603,
0.0274397995827,
0.0271673661154,
0.0268963885645,
0.02662686534,
0.0263587948549,
0.0260921755262,
0.0258270057742,
0.0255632840226,
0.0253010086985,
0.0250401782328,
0.0247807910595,
0.0245228456161,
0.0242663403436,
0.0240112736864,
0.0237576440923,
0.0235054500123,
0.023254689901,
0.0230053622163,
0.0227574654194,
0.0225109979749,
0.0222659583506,
0.0220223450178,
0.021780156451,
0.0215393911279,
0.0213000475297,
0.0210621241408,
0.0208256194487,
0.0205905319444,
0.0203568601219,
0.0201246024786,
0.019893757515,
0.019664323735,
0.0194362996455,
0.0192096837566,
0.0189844745817,
0.0187606706373,
0.018538270443,
0.0183172725217,
0.0180976753993,
0.0178794776048,
0.0176626776704,
0.0174472741314,
0.0172332655262,
0.0170206503963,
0.0168094272861,
0.0165995947433,
0.0163911513186,
0.0161840955655,
0.015978426041,
0.0157741413047,
0.0155712399194,
0.015369720451,
0.0151695814681,
0.0149708215426,
0.0147734392493,
0.0145774331657,
0.0143828018727,
0.0141895439538,
0.0139976579955,
0.0138071425875,
0.0136179963221,
0.0134302177946,
0.0132438056033,
0.0130587583492,
0.0128750746365,
0.0126927530719,
0.0125117922653,
0.0123321908291,
0.012153947379,
0.0119770605332,
0.0118015289127,
0.0116273511416,
0.0114545258467,
0.0112830516573,
0.011112927206,
0.0109441511279,
0.0107767220609,
0.0106106386456,
0.0104458995256,
0.010282503347,
0.0101204487588,
0.00995973441262,
0.00980035896291,
0.00964232106677,
0.00948561938405,
0.00933025257728,
0.00917621931168,
0.00902351825516,
0.0088721480783,
0.00872210745437,
0.00857339505928,
0.00842600957159,
0.0082799496725,
0.00813521404587,
0.00799180137816,
0.00784971035847,
0.00770893967849,
0.00756948803254,
0.0074313541175,
0.00729453663287,
0.00715903428071,
0.00702484576567,
0.00689196979494,
0.00676040507829,
0.00663015032801,
0.00650120425896,
0.00637356558853,
0.0062472330366,
0.00612220532562,
0.00599848118051,
0.00587605932871,
0.00575493850015,
0.00563511742725,
0.00551659484491,
0.00539936949051,
0.00528344010388,
0.00516880542732,
0.00505546420557,
0.00494341518583,
0.00483265711772,
0.0047231887533,
0.00461500884704,
0.00450811615584,
0.00440250943899,
0.00429818745819,
0.00419514897754,
0.00409339276352,
0.00399291758497,
0.00389372221314,
0.00379580542161,
0.00369916598633,
0.00360380268561,
0.0035097143001,
0.00341689961278,
0.00332535740896,
0.00323508647629,
0.00314608560472,
0.00305835358651,
0.00297188921623,
0.00288669129076,
0.00280275860924,
0.00272008997311,
0.00263868418609,
0.00255854005417,
0.00247965638558,
0.00240203199085,
0.00232566568272,
0.00225055627619,
0.0021767025885,
0.00210410343912,
0.00203275764974,
0.00196266404427,
0.00189382144883,
0.00182622869175,
0.00175988460356,
0.00169478801698,
0.0016309377669,
0.00156833269042,
0.0015069716268,
0.00144685341745,
0.00138797690598,
0.00133034093813,
0.00127394436178,
0.00121878602698,
0.00116486478589,
0.00111217949283,
0.00106072900421,
0.00101051217859,
0.000961527876637,
0.000913774961106,
0.000867252296869,
0.000821958750892,
0.000777893192225,
0.000735054492005,
0.000693441523445,
0.000653053161831,
0.000613888284511,
0.000575945770897,
0.000539224502452,
0.000503723362691,
0.000469441237167,
0.000436377013474,
0.000404529581235,
0.0003738978321,
0.000344480659737,
0.00031627695983,
0.000289285630071,
0.000263505570156,
0.000238935681778,
0.000215574868621,
0.000193422036358,
0.000172476092639,
0.000152735947095,
0.000134200511323,
0.000116868698885,
0.000100739425305,
8.58116080572e-05,
7.20841665669e-05,
5.95560222016e-05,
4.82260982667e-05,
3.809332e-05,
2.91566145665e-05,
2.14149110532e-05,
1.48671404637e-05,
9.51223571301e-06,
5.34913162227e-06,
2.37676491371e-06,
5.94074205373e-07,
5.92592610151e-15]

v_sat=[
0.33333334321,
0.333432266186,
0.333531306711,
0.333630465044,
0.333729741446,
0.333829136177,
0.3339286495,
0.334028281679,
0.334128032976,
0.334227903656,
0.334327893986,
0.334428004232,
0.33452823466,
0.33462858554,
0.334729057141,
0.334829649731,
0.334930363584,
0.335031198969,
0.335132156161,
0.335233235433,
0.335334437058,
0.335435761314,
0.335537208476,
0.335638778821,
0.335740472629,
0.335842290177,
0.335944231747,
0.336046297619,
0.336148488076,
0.3362508034,
0.336353243875,
0.336455809787,
0.33655850142,
0.336661319063,
0.336764263003,
0.336867333529,
0.33697053093,
0.337073855497,
0.337177307522,
0.337280887298,
0.337384595119,
0.337488431279,
0.337592396074,
0.337696489802,
0.337800712759,
0.337905065244,
0.338009547559,
0.338114160002,
0.338218902877,
0.338323776486,
0.338428781134,
0.338533917125,
0.338639184766,
0.338744584364,
0.338850116227,
0.338955780665,
0.339061577987,
0.339167508506,
0.339273572534,
0.339379770384,
0.339486102373,
0.339592568815,
0.339699170027,
0.339805906328,
0.339912778036,
0.340019785473,
0.34012692896,
0.340234208819,
0.340341625374,
0.34044917895,
0.340556869873,
0.340664698471,
0.340772665071,
0.340880770003,
0.340989013599,
0.341097396189,
0.341205918108,
0.341314579688,
0.341423381266,
0.341532323179,
0.341641405764,
0.341750629361,
0.341859994309,
0.34196950095,
0.342079149628,
0.342188940685,
0.342298874468,
0.342408951322,
0.342519171596,
0.342629535639,
0.342740043801,
0.342850696432,
0.342961493887,
0.34307243652,
0.343183524685,
0.343294758739,
0.343406139042,
0.34351766595,
0.343629339827,
0.343741161032,
0.343853129931,
0.343965246886,
0.344077512265,
0.344189926435,
0.344302489764,
0.344415202622,
0.344528065381,
0.344641078414,
0.344754242094,
0.344867556797,
0.344981022901,
0.345094640784,
0.345208410824,
0.345322333405,
0.345436408907,
0.345550637716,
0.345665020217,
0.345779556796,
0.345894247843,
0.346009093746,
0.346124094898,
0.346239251691,
0.346354564519,
0.346470033778,
0.346585659866,
0.346701443181,
0.346817384123,
0.346933483095,
0.3470497405,
0.347166156742,
0.347282732228,
0.347399467367,
0.347516362566,
0.347633418239,
0.347750634797,
0.347868012654,
0.347985552228,
0.348103253934,
0.348221118192,
0.348339145423,
0.34845733605,
0.348575690495,
0.348694209185,
0.348812892547,
0.348931741011,
0.349050755005,
0.349169934964,
0.34928928132,
0.34940879451,
0.349528474971,
0.349648323142,
0.349768339463,
0.349888524377,
0.350008878329,
0.350129401765,
0.350250095132,
0.35037095888,
0.35049199346,
0.350613199325,
0.350734576931,
0.350856126734,
0.350977849192,
0.351099744766,
0.351221813918,
0.351344057113,
0.351466474815,
0.351589067494,
0.351711835617,
0.351834779658,
0.35195790009,
0.352081197387,
0.352204672027,
0.352328324489,
0.352452155255,
0.352576164807,
0.352700353631,
0.352824722213,
0.352949271042,
0.35307400061,
0.353198911409,
0.353324003934,
0.353449278683,
0.353574736154,
0.353700376848,
0.353826201269,
0.353952209922,
0.354078403314,
0.354204781954,
0.354331346354,
0.354458097027,
0.35458503449,
0.35471215926,
0.354839471857,
0.354966972803,
0.355094662623,
0.355222541843,
0.355350610992,
0.3554788706,
0.355607321202,
0.355735963332,
0.355864797528,
0.35599382433,
0.356123044279,
0.356252457922,
0.356382065804,
0.356511868474,
0.356641866484,
0.356772060388,
0.356902450741,
0.357033038103,
0.357163823033,
0.357294806096,
0.357425987856,
0.357557368883,
0.357688949746,
0.357820731018,
0.357952713275,
0.358084897095,
0.358217283058,
0.358349871746,
0.358482663746,
0.358615659646,
0.358748860035,
0.358882265507,
0.359015876657,
0.359149694084,
0.359283718388,
0.359417950174,
0.359552390046,
0.359687038615,
0.35982189649,
0.359956964287,
0.360092242622,
0.360227732115,
0.360363433388,
0.360499347066,
0.360635473776,
0.36077181415,
0.360908368821,
0.361045138425,
0.3611821236,
0.36131932499,
0.361456743238,
0.361594378992,
0.361732232903,
0.361870305625,
0.362008597813,
0.362147110127,
0.362285843229,
0.362424797785,
0.362563974463,
0.362703373935,
0.362842996874,
0.362982843958,
0.363122915868,
0.363263213287,
0.363403736903,
0.363544487405,
0.363685465486,
0.363826671842,
0.363968107174,
0.364109772183,
0.364251667576,
0.364393794061,
0.364536152352,
0.364678743163,
0.364821567215,
0.364964625229,
0.365107917932,
0.365251446052,
0.365395210322,
0.365539211478,
0.365683450259,
0.365827927409,
0.365972643674,
0.366117599804,
0.366262796552,
0.366408234675,
0.366553914934,
0.366699838093,
0.366846004921,
0.366992416187,
0.367139072668,
0.367285975143,
0.367433124394,
0.367580521207,
0.367728166372,
0.367876060684,
0.36802420494,
0.368172599941,
0.368321246494,
0.368470145406,
0.368619297493,
0.36876870357,
0.368918364459,
0.369068280985,
0.369218453977,
0.369368884268,
0.369519572697,
0.369670520103,
0.369821727332,
0.369973195235,
0.370124924665,
0.37027691648,
0.370429171542,
0.370581690719,
0.37073447488,
0.370887524901,
0.371040841662,
0.371194426046,
0.371348278942,
0.371502401243,
0.371656793846,
0.371811457652,
0.371966393568,
0.372121602504,
0.372277085377,
0.372432843106,
0.372588876616,
0.372745186836,
0.372901774701,
0.373058641149,
0.373215787124,
0.373373213575,
0.373530921454,
0.373688911721,
0.373847185337,
0.374005743272,
0.374164586499,
0.374323715995,
0.374483132743,
0.374642837733,
0.374802831956,
0.374963116413,
0.375123692106,
0.375284560044,
0.375445721243,
0.37560717672,
0.375768927502,
0.375930974619,
0.376093319105,
0.376255962004,
0.37641890436,
0.376582147227,
0.376745691662,
0.376909538728,
0.377073689495,
0.377238145038,
0.377402906436,
0.377567974777,
0.377733351152,
0.37789903666,
0.378065032404,
0.378231339494,
0.378397959047,
0.378564892183,
0.378732140031,
0.378899703725,
0.379067584406,
0.379235783219,
0.379404301318,
0.379573139862,
0.379742300016,
0.379911782952,
0.380081589848,
0.380251721889,
0.380422180267,
0.380592966179,
0.38076408083,
0.380935525431,
0.3811073012,
0.381279409363,
0.38145185115,
0.381624627801,
0.38179774056,
0.381971190681,
0.382144979423,
0.382319108053,
0.382493577844,
0.382668390078,
0.382843546044,
0.383019047035,
0.383194894357,
0.383371089319,
0.38354763324,
0.383724527445,
0.383901773267,
0.384079372047,
0.384257325134,
0.384435633885,
0.384614299663,
0.384793323841,
0.384972707799,
0.385152452926,
0.385332560617,
0.385513032277,
0.38569386932,
0.385875073165,
0.386056645243,
0.386238586992,
0.386420899858,
0.386603585295,
0.386786644769,
0.38697007975,
0.38715389172,
0.387338082169,
0.387522652595,
0.387707604508,
0.387892939423,
0.388078658867,
0.388264764376,
0.388451257492,
0.388638139772,
0.388825412778,
0.389013078083,
0.389201137269,
0.38938959193,
0.389578443666,
0.38976769409,
0.389957344823,
0.390147397498,
0.390337853756,
0.390528715249,
0.390719983639,
0.3909116606,
0.391103747813,
0.391296246974,
0.391489159785,
0.391682487962,
0.391876233231,
0.392070397328,
0.392264982001,
0.392459989008,
0.39265542012,
0.392851277116,
0.393047561791,
0.393244275947,
0.3934414214,
0.393638999977,
0.393837013517,
0.39403546387,
0.3942343529,
0.394433682481,
0.3946334545,
0.394833670857,
0.395034333462,
0.39523544424,
0.395437005128,
0.395639018075,
0.395841485043,
0.396044408008,
0.396247788958,
0.396451629894,
0.396655932831,
0.396860699797,
0.397065932834,
0.397271633998,
0.397477805358,
0.397684448996,
0.39789156701,
0.398099161511,
0.398307234626,
0.398515788493,
0.398724825267,
0.398934347119,
0.399144356231,
0.399354854804,
0.399565845051,
0.399777329202,
0.399989309501,
0.40020178821,
0.400414767605,
0.400628249976,
0.400842237633,
0.401056732899,
0.401271738114,
0.401487255636,
0.401703287838,
0.40191983711,
0.402136905859,
0.402354496509,
0.402572611502,
0.402791253296,
0.403010424369,
0.403230127213,
0.403450364341,
0.403671138283,
0.403892451588,
0.404114306823,
0.404336706572,
0.404559653441,
0.404783150053,
0.40500719905,
0.405231803095,
0.405456964868,
0.405682687072,
0.405908972427,
0.406135823675,
0.406363243577,
0.406591234917,
0.406819800496,
0.407048943141,
0.407278665695,
0.407508971026,
0.407739862022,
0.407971341593,
0.408203412673,
0.408436078215,
0.408669341198,
0.408903204621,
0.409137671507,
0.409372744903,
0.40960842788,
0.409844723529,
0.410081634971,
0.410319165345,
0.410557317819,
0.410796095585,
0.411035501858,
0.41127553988,
0.411516212918,
0.411757524265,
0.411999477242,
0.412242075192,
0.412485321489,
0.412729219533,
0.412973772748,
0.413218984591,
0.413464412364,
0.41370860401,
0.413953326646,
0.414198672345,
0.414444643966,
0.414691244385,
0.414938476498,
0.41518634322,
0.415434847487,
0.41568389466,
0.415933681923,
0.416184115641,
0.416435098285,
0.416686731427,
0.416939120652,
0.417192064906,
0.417445668803,
0.417699935429,
0.417954867891,
0.418210469317,
0.418466742858,
0.41872358174,
0.418981207944,
0.419239515827,
0.419498395361,
0.419758075202,
0.42001833095,
0.420279279137,
0.420540923056,
0.420803385042,
0.421066431571,
0.421330183849,
0.421594522641,
0.421859695366,
0.422125584044,
0.422392192128,
0.422659395511,
0.422927451586,
0.423196107415,
0.423465625527,
0.423735747894,
0.424006742286,
0.42427834548,
0.424550693834,
0.42482379098,
0.425097640579,
0.425372246314,
0.425647611896,
0.425923741063,
0.426200492424,
0.426478158624,
0.426756599761,
0.427035670137,
0.427315671212,
0.427596306276,
0.427877882818,
0.42816009815,
0.428443108749,
0.42872707731,
0.429011691946,
0.429297113838,
0.429583347033,
0.429870395608,
0.430158263668,
0.430446955348,
0.430736474814,
0.431026826259,
0.431317840299,
0.431609866671,
0.431902737772,
0.432196279038,
0.432490850788,
0.432786097807,
0.433082387652,
0.433379357925,
0.433677195532,
0.43397609485,
0.434275682421,
0.434576150798,
0.434877504533,
0.435179748207,
0.435482886439,
0.435786923877,
0.436091865208,
0.436397715151,
0.43670447846,
0.437012159924,
0.43732076437,
0.437630296658,
0.437940545347,
0.438251945863,
0.438564289001,
0.438877356807,
0.439191597994,
0.439506569422,
0.439822728897,
0.440139624243,
0.44045772255,
0.440776562412,
0.441096381155,
0.441417425698,
0.441739220419,
0.442062009892,
0.442385799477,
0.442710846226,
0.443036654844,
0.443363479933,
0.443691327019,
0.444020201673,
0.444350109505,
0.44468105617,
0.445013047368,
0.44534608884,
0.445680186373,
0.446015345799,
0.446351291613,
0.446688589617,
0.447026967251,
0.447366430527,
0.44770698551,
0.448048342195,
0.44839109592,
0.448734959789,
0.449079634714,
0.449425734538,
0.449772963383,
0.45012101277,
0.450470515668,
0.450820845496,
0.451172648327,
0.451525284535,
0.451879413591,
0.452234382532,
0.452590864525,
0.452948192972,
0.453306709571,
0.453666770203,
0.454027687236,
0.454390169446,
0.454753514778,
0.45511808297,
0.455484248764,
0.455851287857,
0.456219571308,
0.45658948569,
0.456960283689,
0.457332348069,
0.457705686275,
0.458080701301,
0.458456613903,
0.458833823084,
0.459212336538,
0.45959216202,
0.459973724129,
0.4603562016,
0.460740014807,
0.461125171764,
0.461511680556,
0.461899549331,
0.462289230311,
0.462679848501,
0.463071851591,
0.463465248008,
0.463860046249,
0.464256254883,
0.46465435575,
0.465053416236,
0.465453913317,
0.465855855858,
0.466259252798,
0.46666411315,
0.467070446007,
0.467478260538,
0.467888081477,
0.468298892752,
0.46871121375,
0.469125053961,
0.469540422956,
0.469957330388,
0.470376335962,
0.470796355558,
0.471217943133,
0.471641108681,
0.472065862283,
0.472492214111,
0.472920761468,
0.473350347061,
0.473781562009,
0.474214416843,
0.474648922192,
0.475085708875,
0.475523554367,
0.475963082905,
0.476404305501,
0.476847881321,
0.477292532662,
0.477738911772,
0.478187700031,
0.478637576498,
0.479089215367,
0.47954332108,
0.479998527799,
0.480455532501,
0.480915063587,
0.481375708576,
0.481838920737,
0.482303255484,
0.48277019907,
0.483238273964,
0.483709000261,
0.484180866627,
0.484655427883,
0.485131138005,
0.485609587449,
0.486089194588,
0.486571586453,
0.487055974911,
0.487541534416,
0.488029948703,
0.48852040207,
0.489012039891,
0.489506604894,
0.490003252693,
0.490501998188,
0.491002856422,
0.491504921619,
0.492010040242,
0.492517317465,
0.493026768923,
0.493538410402,
0.494052257842,
0.494568327341,
0.495086635152,
0.495607197691,
0.496130031533,
0.496655153416,
0.497182580247,
0.497713389917,
0.498245490755,
0.498779948442,
0.499316780562,
0.49985711775,
0.500398765669,
0.500942842029,
0.501490519019,
0.502039521401,
0.502592190106,
0.503146193999,
0.503703931493,
0.504263013929,
0.504825898875,
0.505390138471,
0.505958251162,
0.50652901626,
0.507102454698,
0.5076772672,
0.508256099486,
0.508837669004,
0.509421997581,
0.510009107276,
0.510599020383,
0.511191759431,
0.511787347189,
0.51238580667,
0.512987161129,
0.513591434072,
0.514200165684,
0.514810366595,
0.515423558318,
0.516039765385,
0.516660608833,
0.51728294195,
0.517910003977,
0.518538565763,
0.519171951423,
0.519808550081,
0.520446663439,
0.521089748061,
0.521736128737,
0.522384038596,
0.523037073056,
0.523693489452,
0.524353317187,
0.525016585999,
0.525683325964,
0.5263535675,
0.527027341372,
0.527706676823,
0.528387636331,
0.52907222304,
0.529762550537,
0.530454517269,
0.531150209387,
0.531851829129,
0.532557301656,
0.533264432687,
0.533977686824,
0.534694901399,
0.535413788052,
0.5361390018,
0.536868287545,
0.537601683564,
0.538339228593,
0.539080961841,
0.53982692299,
0.540577152201,
0.541334295745,
0.542093221423,
0.54285653927,
0.543627012998,
0.544399282161,
0.545178874677,
0.545960270823,
0.546749162943,
0.547569169946,
0.548442110861,
0.549202658896,
0.549967967533,
0.550764959092,
0.551581841769,
0.5524067654,
0.553233802628,
0.554069012477,
0.554906448771,
0.555752193829,
0.556603305429,
0.557459849361,
0.558321892658,
0.559189503633,
0.560062751911,
0.560941708462,
0.561829500057,
0.562720096858,
0.563619688318,
0.564522226253,
0.565433924384,
0.566348716454,
0.567272840503,
0.568203303969,
0.569140191627,
0.570083590012,
0.571033587464,
0.571990274182,
0.572953742277,
0.573927209071,
0.574904529367,
0.575892053185,
0.576883618393,
0.577885600434,
0.578894970243,
0.579908680065,
0.580933143824,
0.581965323935,
0.583008505435,
0.584056469689,
0.585112501916,
0.586176724843,
0.587252455265,
0.588336640928,
0.589426211861,
0.590527700912,
0.591638049809,
0.592757400081,
0.593885896785,
0.595023688623,
0.596174160116,
0.597331008474,
0.598500863257,
0.599677409752,
0.600867305985,
0.602067483147,
0.603278119147,
0.604499396707,
0.605734775171,
0.606977908921,
0.608232263057,
0.60950132732,
0.610782034806,
0.612074600999,
0.613379247635,
0.614696202954,
0.616025701956,
0.617371300415,
0.6187266246,
0.620098563389,
0.621484067773,
0.622883410758,
0.624296873991,
0.625724748137,
0.627167333275,
0.62862828724,
0.630104590238,
0.631596572901,
0.633104577094,
0.63462895644,
0.636173444305,
0.637731688197,
0.639310818837,
0.640907874999,
0.642523277779,
0.644157463925,
0.645814274492,
0.647490798177,
0.649184129297,
0.650904957166,
0.652643627596,
0.654404083553,
0.656190300951,
0.65799947519,
0.659832226231,
0.661692611587,
0.663577898775,
0.665485377391,
0.667426026781,
0.66939037302,
0.671386054397,
0.673410497857,
0.675464586986,
0.677552669191,
0.679668877136,
0.681821074269,
0.68401033558,
0.686234371825,
0.68849437529,
0.690791604002,
0.693130802686,
0.695509956612,
0.697930552183,
0.700397574025,
0.702912685166,
0.705470845672,
0.708080753331,
0.710744409123,
0.713460557753,
0.716231495175,
0.719063058068,
0.721957864922,
0.724915364953,
0.727938609869,
0.731034240438,
0.73420579205,
0.737457096535,
0.740789003253,
0.744206087076,
0.747719926916,
0.751329375265,
0.755043722014,
0.75886957882,
0.762814274633,
0.766885968276,
0.771093784654,
0.775447980913,
0.779960150978,
0.784646575782,
0.789519190818,
0.794598428527,
0.799901426234,
0.805454889256,
0.811286870906,
0.81743391879,
0.823934122666,
0.830841037612,
0.838218641303,
0.846154808783,
0.854756618608,
0.864180402825,
0.874649306024,
0.886502120741,
0.900318321131,
0.91722511986,
0.940145551582,
0.999367900697,
1.00063281212,
1.06707939354,
1.09726275231,
1.12146944046,
1.14262106098,
1.16184909181,
1.17972568763,
1.19660003125,
1.21269251403,
1.22815035212,
1.24309886715,
1.25761161371,
1.27175762605,
1.28558223116,
1.2991407438,
1.31246021943,
1.3255719966,
1.3384897015,
1.35124890177,
1.3638555921,
1.37634187963,
1.38870821903,
1.40096770075,
1.41313214493,
1.42521230588,
1.4372180386,
1.44915843571,
1.46104194109,
1.472854193,
1.48464623198,
1.4963796564,
1.50805840233,
1.51971187972,
1.53134611067,
1.54296689814,
1.55455113379,
1.56610131846,
1.5776504408,
1.58920362427,
1.60073312884,
1.61224075433,
1.6237630417,
1.63530475329,
1.64679642583,
1.65831247025,
1.66985749132,
1.68139556038,
1.69292774839,
1.70449795903,
1.71606660227,
1.72763454344,
1.73920256903,
1.75081934553,
1.76248944365,
1.77411631272,
1.78580043187,
1.79749312672,
1.80919492881,
1.82096246306,
1.83268530879,
1.84453669823,
1.85634425184,
1.86816592125,
1.88006565075,
1.89198322784,
1.90391896257,
1.91594155237,
1.92798611027,
1.93998115968,
1.95214221946,
1.96425422996,
1.97638912834,
1.98862582555,
2.00088932451,
2.01317980146,
2.02549740344,
2.03792849422,
2.05030262284,
2.0627943555,
2.07531757979,
2.08787240306,
2.10045890699,
2.11307714776,
2.12582774536,
2.13861449086,
2.15143747398,
2.16429676129,
2.17719239633,
2.19012439954,
2.2032070331,
2.21621415579,
2.22937674065,
2.24258057248,
2.25582567982,
2.26911207008,
2.28243972934,
2.29580862222,
2.30935341546,
2.32294480814,
2.33644256573,
2.35012440179,
2.36385283765,
2.37762784874,
2.3914493903,
2.40547235401,
2.41938982403,
2.43351479264,
2.447527967,
2.46175484031,
2.47603422508,
2.49036609042,
2.50475038604,
2.51918704193,
2.5338605804,
2.54840523738,
2.56300198116,
2.57784616472,
2.5927496117,
2.60771231097,
2.62252728603,
2.6376044417,
2.65274063842,
2.6681547474,
2.68341287492,
2.69872978279,
2.7143368988,
2.7297752376,
2.74551225114,
2.76107153117,
2.77693815484,
2.79287174486,
2.80887224306,
2.82493957134,
2.84107363118,
2.85727430317,
2.87354144653,
2.89015840957,
2.90656318072,
2.92332795269,
2.93986985874,
2.95678220243,
2.97346057568,
2.99052008509,
3.00765584069,
3.02486776724,
3.04215576802,
3.05951972427,
3.07695949463,
3.09447491451,
3.11242405209,
3.13009660987,
3.14821552838,
3.16604469236,
3.18433319088,
3.2046680558,
3.22875368538,
3.25313501453,
3.26149612217,
3.27638315905,
3.29503009182,
3.31417800392,
3.33300239768,
3.35233344416,
3.37133888285,
3.39085675354,
3.4104704575,
3.4297552681,
3.44956141567,
3.46946626159,
3.48947077848,
3.50957594417,
3.52978274181,
3.55009216012,
3.57050519353,
3.59146602369,
3.61209159153,
3.63282381876,
3.6541139228,
3.67506490617,
3.69612565194,
3.7177546461,
3.73950044326,
3.76090169648,
3.78288195114,
3.80498240762,
3.82673404142,
3.8490757456,
3.8715411265,
3.89413136971,
3.91684767019,
3.93969123246,
3.96266327077,
3.98576500937,
4.00948980241,
4.03285752927,
4.05635872095,
4.08049554163,
4.10427043918,
4.12818266448,
4.15274347488,
4.17693732844,
4.20178865653,
4.22626956101,
4.25141701057,
4.27671628653,
4.302168864,
4.32724380381,
4.35300409795,
4.37892216909,
4.4049995502,
4.4312377894,
4.4576384503,
4.48420311219,
4.51093337034,
4.53783083628,
4.56489713805,
4.59213392049,
4.62011436145,
4.64770089214,
4.67546298178,
4.70340234567,
4.73210769912,
4.76041077891,
4.78949144162,
4.81816549126,
4.84762896994,
4.8766814036,
4.90653537179,
4.9359737692,
4.96622607285,
4.99668274217,
5.02671684791,
5.05758400546,
5.08866178218,
5.11995232766,
5.15081062364,
5.18252855833,
5.21446581167,
5.24662463615,
5.27900731122,
5.31161614372,
5.34445346836,
5.37752164818,
5.41082307499,
5.4443601699,
5.47813538375,
5.51215119765,
5.54711728157,
5.58162723072,
5.61638547045,
5.65139460881,
5.68665728674,
5.72291092003,
5.75869441509,
5.79473964012,
5.83180148609,
5.86838442302,
5.90523760208,
5.94313400332,
5.98054245721,
6.01901247868,
6.05698835213,
6.09604459011,
6.13460035386,
6.17425574444,
6.21340420668,
6.25367203775,
6.29342635601,
6.33432027969,
6.37469397322,
6.41622801882,
6.45809109382,
6.49942356893,
6.54194863364,
6.58481402288,
6.62713812594,
6.67068830742,
6.71459059449,
6.75794058305,
6.80255145121,
6.8475267189,
6.89287063624,
6.93764701861,
6.98373293243,
7.03020052012,
7.07705428639,
7.12429880299,
7.1709558349,
7.21898700189,
7.26742293659,
7.31626849007,
7.36552858703,
7.41520822721,
7.46427505996,
7.51479955112,
7.5657589254,
7.61715849547,
7.66900365653,
7.72129988797,
7.77295641,
7.82616125075,
7.87983398503,
7.93398044358,
7.98860654996,
8.04371832235,
8.0993218755,
8.15542342266,
8.21084672103,
8.26795182868,
8.32557402502,
8.38371993505,
8.44239629266,
8.50160994291,
8.56011435167,
8.62041113272,
8.68126625865,
8.74268703969,
8.80468090922,
8.8672554264,
8.92908776944,
8.99283324932,
9.05718264376,
9.12214403893,
9.18772566073,
9.2525361186,
9.31936892736,
9.38684729921,
9.45498004614,
9.52231738915,
9.59177057086,
9.66190528473,
9.73122580062,
9.80273603934,
9.87495643742,
9.9463432699,
10.0199972836,
10.0928045457,
10.1679325024,
10.2438217864,
10.3188439616,
10.3962707374,
10.4728165469,
10.5518249741,
10.6299383015,
10.7105741945,
10.7903005738,
10.8726114799,
10.9539981733,
11.0362233402,
11.1211295351,
11.205089016,
11.2899245616,
11.3775426299,
11.4641908241,
11.5517548907,
11.6402485036,
11.7296856032,
11.8220857732,
11.9134761011,
12.0058537766,
12.0992338795,
12.1936317903,
12.2890631978,
12.3855441069,
12.4830908462,
12.5817200769,
12.6814488003,
12.7822943673,
12.8819903278,
12.9850951302,
13.089370541,
13.1948353904,
13.2991108143,
13.4069827332,
13.5161024866,
13.6240019879,
13.7356477904,
13.8460523843,
13.9603074757,
14.073300008,
14.1902512422,
14.3059181711,
14.4229388857,
14.5440878076,
14.6639192024,
14.7851738592,
14.9078757557,
15.0320494004,
15.1577198464,
15.2849127074,
15.4136541731,
15.5439710252,
15.6758906541,
15.8094410769,
15.9446509545,
16.0815496105,
16.2169035601,
16.3572258516,
16.4993282147,
16.6398440581,
16.7855565605,
16.929654172,
17.0791079844,
17.2269180498,
17.3766105127,
17.5319101787,
17.685522114,
17.8411222499,
17.9987472401,
18.1584346292,
18.3202228796,
18.4841513995,
18.6502605723,
18.8185917865,
18.9849948308,
19.1578369757,
19.3330304227,
19.5062417203,
19.6862107222,
19.8641610157,
20.0490924904,
20.2319681339,
20.4173448978,
20.6100558102,
20.8006544584,
20.9939061227,
21.1898636069,
21.3885811039,
21.5901142417,
21.7945201307,
22.0018574137,
22.2067832457,
22.4200805918,
22.6309206013,
22.8504247729,
23.0674250583,
23.293396422,
23.5168167278,
23.7435019386,
23.9735204486,
24.2131652791,
24.4501637307,
24.6907145791,
24.9283631611,
25.1761428396,
25.4277084262,
25.6831430807,
25.9355595525,
26.1988738224,
26.4591112127,
26.723329607,
26.9990660572,
27.271636794,
27.5484617601,
27.8296364929,
28.1152593764,
28.4054317475,
28.700258007,
28.9914543391,
29.2957665417,
29.6050617579,
29.9106165098,
30.2210803495,
30.5457200442,
30.8665081695,
31.1925609106,
31.5240029231,
31.8609627839,
32.2035731463,
32.551970903,
32.9062973557,
33.256131928,
33.3873783997,
33.466017327,
33.5449458939,
33.6241657851,
33.703678698,
33.7834863433,
33.8635904442,
33.9439927374,
34.0246949727,
34.1056989134,
34.1870063361,
34.2686190314,
34.3505388033,
34.4327674701,
34.5153068638,
34.598158831,
34.6813252323,
34.7648079429,
34.8486088526,
34.932729866,
35.0171729026,
35.1019398971,
35.187032799,
35.2724535737,
35.3582042017,
35.4442866793,
35.5307030187,
35.6174552481,
35.7045454117,
35.7919755701,
35.8797478005,
35.9678641964,
36.0563268685,
36.1451379442,
36.2342995682,
36.3238139025,
36.4136831267,
36.5039094378,
36.594495051,
36.6854421993,
36.7767531341,
36.8684301251,
36.9604754609,
37.0528914484,
37.1456804141,
37.2388447031,
37.3323866804,
37.4263087304,
37.5206132573,
37.6153026853,
37.7103794589,
37.805846043,
37.9017049232,
37.9979586059,
38.0946096187,
38.1916605105,
38.2891138515,
38.3869722342,
38.4852382725,
38.5839146031,
38.6830038848,
38.7825087993,
38.8824320512,
38.9827763685,
39.0835445023,
39.1847392278,
39.2863633441,
39.3884196743,
39.4909110664,
39.5938403928,
39.6972105512,
39.8010244646,
39.9052850815,
40.0099953763,
40.1151583497,
40.2207770287,
40.3268544671,
40.433393746,
40.5403979734,
40.6478702853,
40.7558138457,
40.8642318465,
40.9731275087,
41.082504082,
41.1923648452,
41.3027131069,
41.4135522055,
41.5248855099,
41.6367164193,
41.7490483639,
41.8618848055,
41.9752292373,
42.0890851845,
42.2034562049,
42.318345889,
42.4337578604,
42.5496957763,
42.6661633279,
42.7831642406,
42.9007022747,
43.0187812254,
43.1374049236,
43.2565772362,
43.3763020665,
43.4965833546,
43.6174250778,
43.7388312511,
43.8608059278,
43.9833531998,
44.1064771978,
44.2301820924,
44.354472094,
44.4793514537,
44.6048244632,
44.7308954562,
44.857568808,
44.9848489366,
45.112740303,
45.2412474116,
45.3703748111,
45.5001270946,
45.6305089007,
45.7615249133,
45.893179863,
46.025478527,
46.1584257301,
46.2920263451,
46.4262852935,
46.561207546,
46.6967981232,
46.8330620962,
46.9700045872,
47.1076307704,
47.2459458721,
47.3849551722,
47.5246640038,
47.6650777551,
47.806201869,
47.9480418445,
48.0906032373,
48.2338916604,
48.3779127846,
48.52267234,
48.6681761161,
48.8144299627,
48.9614397908,
49.1092115737,
49.257751347,
49.4070652104,
49.5571593277,
49.7080399283,
49.8597133076,
50.0121858282,
50.1654639206,
50.3195540843,
50.4744628885,
50.6301969732,
50.7867630501,
50.9441679036,
51.1024183918,
51.2615214474,
51.4214840788,
51.5823133713,
51.7440164877,
51.9066006699,
52.0700732397,
52.2344415999,
52.3997132355,
52.5658957149,
52.7329966908,
52.9010239018,
53.0699851733,
53.2398884187,
53.4107416409,
53.5825529334,
53.7553304816,
53.9290825639,
54.1038175535,
54.2795439194,
54.4562702279,
54.634005144,
54.8127574328,
54.9925359608,
55.1733496977,
55.3552077177,
55.5381192012,
55.7220934359,
55.9071398189,
56.0932678581,
56.2804871739,
56.4688075008,
56.658238689,
56.8487907063,
57.0404736399,
57.2332976981,
57.427273212,
57.6224106375,
57.8187205573,
58.0162136826,
58.2149008552,
58.4147930494,
58.6159013741,
58.8182370749,
59.0218115361,
59.2266362831,
59.4327229842,
59.6400834532,
59.8487296512,
60.0586736896,
60.2699278319,
60.4825044962,
60.6964162579,
60.911675852,
61.1282961754,
61.3462902902,
61.5656714256,
61.7864529808,
62.0086485281,
62.2322718152,
62.4573367686,
62.6838574957,
62.9118482887,
63.1413236269,
63.3722981801,
63.6047868119,
63.8388045824,
64.074366752,
64.3114887844,
64.5501863502,
64.7904753301,
65.0323718187,
65.2758921283,
65.5210527918,
65.7678705675,
66.016362442,
66.2665456348,
66.5184376019,
66.7720560401,
67.027418891,
67.2845443454,
67.5434508475,
67.8041570993,
68.0666820655,
68.3310449776,
68.597265339,
68.8653629297,
69.1353578109,
69.4072703308,
69.6811211289,
69.9569311418,
70.2347216083,
70.5145140749,
70.7963304016,
71.0801927672,
71.3661236758,
71.6541459619,
71.9442827974,
72.2365576972,
72.5309945258,
72.827617504,
73.1264512151,
73.4275206123,
73.7308510253,
74.0364681674,
74.3443981431,
74.6546674552,
74.9673030129,
75.2823321389,
75.5997825782,
75.9196825056,
76.2420605347,
76.5669457257,
76.894367595,
77.2243561234,
77.5569417659,
77.8921554608,
78.2300286393,
78.5705932355,
78.9138816964,
79.2599269923,
79.6087626273,
79.9604226505,
80.3149416664,
80.672354847,
81.0326979433,
81.3960072969,
81.7623198527,
82.1316731712,
82.5041054415,
82.8796554945,
83.2583628163,
83.6402675624,
84.0254105715,
84.4138333805,
84.8055782393,
85.2006881261,
85.5992067633,
86.0011786337,
86.4066489969,
86.8156639065,
87.2282702277,
87.6445156549,
88.0644487305,
88.4881188636,
88.9155763494,
89.3468723895,
89.7820591119,
90.2211895926,
90.6643178767,
91.111499001,
91.5627890168,
92.0182450133,
92.4779251416,
92.9418886398,
93.4101958586,
93.882908287,
94.3600885797,
94.8418005848,
95.3281093724,
95.8190812638,
96.3147838616,
96.8152860814,
97.3206581832,
97.8309718046,
98.3462999948,
98.8667172494,
99.3922995463,
99.9231243832,
100.459270815,
101.000819495,
101.547852711,
102.100454434,
102.658710354,
103.222707931,
103.792536434,
104.368286994,
104.95005265,
105.537928401,
106.132011253,
106.732400279,
107.33919667,
107.952503793,
108.572427251,
109.199074941,
109.832557119,
110.472986465,
111.120478147,
111.775149895,
112.437122068,
113.106517729,
113.783462725,
114.468085759,
115.160518479,
115.860895558,
116.569354783,
117.286037144,
118.011086932,
118.74465183,
119.486883017,
120.237935274,
120.997967085,
121.767140757,
122.545622528,
123.333582693,
124.131195725,
124.938640406,
125.756099957,
126.583762183,
127.42181961,
128.270469642,
129.129914708,
130.000362432,
130.882025791,
131.775123298,
132.679879177,
133.596523552,
134.525292644,
135.466428972,
136.420181567,
137.386806189,
138.366565558,
139.359729593,
140.366575657,
141.387388818,
142.422462118,
143.472096855,
144.536602871,
145.616298864,
146.711512701,
147.822581754,
148.949853244,
150.093684604,
151.254443859,
152.432510017,
153.628273489,
154.842136512,
156.074513607,
157.325832051,
158.596532367,
159.887068846,
161.197910087,
162.529539564,
163.882456223,
165.257175106,
166.654228002,
168.074164137,
169.517550893,
170.984974564,
172.477041153,
173.994377203,
175.537630679,
177.107471888,
178.704594454,
180.329716337,
181.983580911,
183.6669581,
185.380645574,
187.125470006,
188.902288408,
190.711989533,
192.555495356,
194.433762647,
196.34778462,
198.298592694,
200.287258339,
202.314895046,
204.382660403,
206.491758302,
208.643441278,
210.839012986,
213.079830845,
215.367308829,
217.70292045,
220.088201921,
222.524755528,
225.014253224,
227.558440452,
230.159140232,
232.818257514,
235.53778384,
238.319802315,
241.166492933,
244.080138275,
247.063129619,
250.11797348,
253.247298646,
256.45386372,
259.740565235,
263.110446383,
266.566706417,
270.112710786,
273.752002067,
277.488311772,
281.325573119,
285.267934842,
289.319776161,
293.485723012,
297.770665671,
302.179777904,
306.71853782,
311.392750576,
316.208573157,
321.172541439,
326.291599787,
331.573133481,
337.025004267,
342.655589417,
348.473824683,
354.489251632,
360.71206987,
367.15319476,
373.824321336,
380.737995176,
387.907691157,
395.347901129,
403.074231696,
411.103513507,
419.453923658,
428.14512309,
437.198411149,
446.63689989,
456.485711105,
466.772199631,
477.526207101,
488.780351109,
500.570355677,
512.935430089,
525.91870455,
539.567732861,
553.935074475,
569.078970931,
585.064135034,
601.962675315,
619.855183637,
638.832020544,
658.994841612,
680.458419225,
703.352828698,
727.826086707,
754.047355093,
782.210856618,
812.54069435,
845.29682771,
880.782542504,
919.353869668,
961.431572741,
1007.51656032,
1058.20992221,
1114.23929278,
1176.49400203,
1246.07263285,
1324.34841213,
1413.06075816,
1514.44606233,
1631.42883118,
1767.90839865,
1929.2020254,
2122.75385513,
2359.31650312,
2655.01882512,
3035.20603439,
3542.11987169,
4251.79479521,
5316.29782239,
7090.4452424,
10638.6504784,
21282.5553487,
213123052.673]

p_sat=[
1.1851852203e-15,
1.18814841075e-07,
4.75352982743e-07,
1.06982632445e-06,
1.9024471426e-06,
2.97342809275e-06,
4.28298221065e-06,
5.83132291331e-06,
7.618664e-06,
9.64521965335e-06,
1.19112044403e-05,
1.44168333134e-05,
1.71623216114e-05,
2.0147885061e-05,
2.33737397771e-05,
2.68401022646e-05,
3.0547189419e-05,
3.44952185279e-05,
3.86844072715e-05,
4.31149737242e-05,
4.77871363556e-05,
5.27011140313e-05,
5.78571260143e-05,
6.3255391966e-05,
6.88961319473e-05,
7.47795664199e-05,
8.0905916247e-05,
8.72754026948e-05,
9.38882474334e-05,
0.000100744672538,
0.00010784490049,
0.000115189154179,
0.000122777656902,
0.000130610632366,
0.000138688304689,
0.000147010898401,
0.000155578638445,
0.000164391750178,
0.000173450459374,
0.000182754992221,
0.000192305575327,
0.000202102435719,
0.000212145800842,
0.000222435898565,
0.000232972957178,
0.000243757205395,
0.000254788872356,
0.000266068187626,
0.000277595381197,
0.000289370683491,
0.000301394325359,
0.000313666538084,
0.00032618755338,
0.000338957603395,
0.000351976920712,
0.00036524573835,
0.000378764289766,
0.000392532808853,
0.000406551529947,
0.000420820687823,
0.0004353405177,
0.000450111255237,
0.000465133136543,
0.00048040639817,
0.000495931277117,
0.000511708010833,
0.000527736837218,
0.000544017994622,
0.000560551721848,
0.000577338258152,
0.000594377843247,
0.000611670717302,
0.000629217120943,
0.000647017295258,
0.000665071481792,
0.000683379922555,
0.00070194286002,
0.000720760537122,
0.000739833197266,
0.000759161084321,
0.000778744442628,
0.000798583516995,
0.000818678552704,
0.000839029795509,
0.000859637491639,
0.000880501887798,
0.000901623231167,
0.000923001769408,
0.000944637750659,
0.000966531423544,
0.000988683037166,
0.00101109284111,
0.00103376108546,
0.00105668802078,
0.0010798738981,
0.00110331896898,
0.00112702348545,
0.00115098770003,
0.00117521186574,
0.0011996962361,
0.00122444106512,
0.00124944660732,
0.00127471311771,
0.00130024085179,
0.0013260300656,
0.00135208101566,
0.00137839395899,
0.00140496915313,
0.00143180685614,
0.00145890732657,
0.0014862708235,
0.00151389760651,
0.0015417879357,
0.00156994207169,
0.00159836027563,
0.00162704280917,
0.0016559899345,
0.00168520191432,
0.00171467901186,
0.00174442149087,
0.00177442961566,
0.00180470365103,
0.00183524386234,
0.00186605051546,
0.00189712387681,
0.00192846421335,
0.00196007179258,
0.00199194688252,
0.00202408975176,
0.0020565006694,
0.00208917990512,
0.00212212772913,
0.00215534441218,
0.00218883022558,
0.00222258544121,
0.00225661033147,
0.00229090516933,
0.00232547022833,
0.00236030578255,
0.00239541210663,
0.0024307894758,
0.00246643816583,
0.00250235845305,
0.00253855061438,
0.0025750149273,
0.00261175166985,
0.00264876112066,
0.00268604355892,
0.00272359926442,
0.0027614285175,
0.00279953159911,
0.00283790879075,
0.00287656037453,
0.00291548663314,
0.00295468784985,
0.00299416430853,
0.00303391629363,
0.0030739440902,
0.00311424798389,
0.00315482826094,
0.0031956852082,
0.00323681911311,
0.00327823026371,
0.00331991894866,
0.00336188545722,
0.00340413007926,
0.00344665310525,
0.00348945482629,
0.00353253553408,
0.00357589552096,
0.00361953507986,
0.00366345450435,
0.00370765408861,
0.00375213412746,
0.00379689491634,
0.00384193675132,
0.00388725992909,
0.003932864747,
0.003978751503,
0.00402492049571,
0.00407137202437,
0.00411810638887,
0.00416512388974,
0.00421242482816,
0.00426000950595,
0.00430787822558,
0.00435603129019,
0.00440446900356,
0.00445319167012,
0.00450219959498,
0.00455149308389,
0.00460107244327,
0.00465093798021,
0.00470109000246,
0.00475152881846,
0.00480225473729,
0.00485326806873,
0.00490456912322,
0.0049561582119,
0.00500803564656,
0.00506020173971,
0.00511265680451,
0.00516540115484,
0.00521843510525,
0.00527175897098,
0.00532537306799,
0.00537927771291,
0.00543347322308,
0.00548795991655,
0.00554273811206,
0.00559780812907,
0.00565317028774,
0.00570882490895,
0.00576477231429,
0.00582101282606,
0.00587754676729,
0.00593437446174,
0.00599149623386,
0.00604891240886,
0.00610662331267,
0.00616462927194,
0.00622293061407,
0.00628152766719,
0.00634042076016,
0.00639961022261,
0.00645909638487,
0.00651887957807,
0.00657896013404,
0.00663933838539,
0.00670001466548,
0.00676098930843,
0.00682226264911,
0.00688383502317,
0.006945706767,
0.00700787821777,
0.00707034971344,
0.00713312159272,
0.0071961941951,
0.00725956786086,
0.00732324293104,
0.00738721974749,
0.00745149865283,
0.00751607999047,
0.00758096410463,
0.00764615134031,
0.00771164204332,
0.00777743656024,
0.0078435352385,
0.00790993842631,
0.0079766464727,
0.0080436597275,
0.00811097854136,
0.00817860326576,
0.00824653425299,
0.00831477185618,
0.00838331642926,
0.00845216832702,
0.00852132790506,
0.00859079551984,
0.00866057152863,
0.00873065628958,
0.00880105016165,
0.00887175350466,
0.0089427666793,
0.0090140900471,
0.00908572397044,
0.00915766881257,
0.00922992493761,
0.00930249271054,
0.00937537249722,
0.00944856466437,
0.00952206957959,
0.00959588761137,
0.00967001912909,
0.00974446450298,
0.00981922410421,
0.0098942983048,
0.0099696874777,
0.0100453919967,
0.0101214122367,
0.0101977485731,
0.0102744013826,
0.0103513710427,
0.0104286579317,
0.010506262429,
0.0105841849147,
0.0106624257701,
0.0107409853772,
0.0108198641191,
0.0108990623797,
0.0109785805439,
0.0110584189976,
0.0111385781276,
0.0112190583215,
0.0112998599682,
0.0113809834573,
0.0114624291794,
0.0115441975261,
0.01162628889,
0.0117087036646,
0.0117914422445,
0.0118745050251,
0.0119578924029,
0.0120416047754,
0.0121256425411,
0.0122100060994,
0.0122946958508,
0.0123797121967,
0.0124650555397,
0.0125507262833,
0.0126367248318,
0.0127230515909,
0.0128097069672,
0.0128966913681,
0.0129840052024,
0.0130716488796,
0.0131596228104,
0.0132479274066,
0.013336563081,
0.0134255302474,
0.0135148293206,
0.0136044607167,
0.0136944248526,
0.0137847221465,
0.0138753530174,
0.0139663178857,
0.0140576171726,
0.0141492513006,
0.0142412206931,
0.0143335257748,
0.0144261669713,
0.0145191447094,
0.0146124594171,
0.0147061115233,
0.0148001014582,
0.014894429653,
0.0149890965402,
0.0150841025532,
0.0151794481266,
0.0152751336963,
0.0153711596992,
0.0154675265734,
0.015564234758,
0.0156612846936,
0.0157586768216,
0.0158564115848,
0.015954489427,
0.0160529107934,
0.0161516761303,
0.0162507858849,
0.016350240506,
0.0164500404435,
0.0165501861483,
0.0166506780727,
0.0167515166701,
0.0168527023953,
0.016954235704,
0.0170561170535,
0.017158346902,
0.0172609257093,
0.017363853936,
0.0174671320443,
0.0175707604975,
0.0176747397601,
0.0177790702982,
0.0178837525787,
0.0179887870701,
0.018094174242,
0.0181999145654,
0.0183060085126,
0.018412456557,
0.0185192591736,
0.0186264168386,
0.0187339300292,
0.0188417992245,
0.0189500249043,
0.0190586075503,
0.0191675476452,
0.019276845673,
0.0193865021192,
0.0194965174708,
0.0196068922157,
0.0197176268435,
0.0198287218453,
0.0199401777131,
0.0200519949408,
0.0201641740232,
0.020276715457,
0.0203896197399,
0.0205028873711,
0.0206165188514,
0.0207305146827,
0.0208448753687,
0.0209596014142,
0.0210746933256,
0.0211901516107,
0.0213059767788,
0.0214221693406,
0.0215387298082,
0.0216556586954,
0.0217729565172,
0.0218906237903,
0.0220086610327,
0.0221270687641,
0.0222458475055,
0.0223649977795,
0.0224845201103,
0.0226044150235,
0.0227246830462,
0.0228453247072,
0.0229663405367,
0.0230877310665,
0.02320949683,
0.023331638362,
0.0234541561991,
0.0235770508794,
0.0237003229424,
0.0238239729295,
0.0239480013834,
0.0240724088487,
0.0241971958714,
0.0243223629992,
0.0244479107813,
0.0245738397689,
0.0247001505144,
0.0248268435721,
0.024953919498,
0.0250813788496,
0.0252092221861,
0.0253374500686,
0.0254660630596,
0.0255950617234,
0.0257244466262,
0.0258542183356,
0.0259843774212,
0.026114924454,
0.0262458600072,
0.0263771846553,
0.0265088989749,
0.0266410035441,
0.0267734989428,
0.026906385753,
0.0270396645581,
0.0271733359435,
0.0273074004963,
0.0274418588055,
0.027576711462,
0.0277119590583,
0.0278476021889,
0.0279836414501,
0.0281200774402,
0.0282569107591,
0.0283941420088,
0.0285317717931,
0.0286698007177,
0.0288082293902,
0.0289470584201,
0.029086288419,
0.0292259200001,
0.0293659537789,
0.0295063903725,
0.0296472304002,
0.0297884744833,
0.0299301232449,
0.0300721773102,
0.0302146373063,
0.0303575038625,
0.0305007776101,
0.0306444591821,
0.030788549214,
0.030933048343,
0.0310779572085,
0.0312232764521,
0.0313690067172,
0.0315151486495,
0.0316617028968,
0.0318086701088,
0.0319560509377,
0.0321038460375,
0.0322520560644,
0.032400681677,
0.0325497235357,
0.0326991823034,
0.032849058645,
0.0329993532277,
0.0331500667208,
0.033301199796,
0.033452753127,
0.0336047273901,
0.0337571232634,
0.0339099414276,
0.0340631825657,
0.0342168473628,
0.0343709365063,
0.0345254506862,
0.0346803905945,
0.0348357569258,
0.0349915503768,
0.0351477716469,
0.0353044214375,
0.0354615004527,
0.0356190093989,
0.0357769489848,
0.0359353199217,
0.0360941229233,
0.0362533587058,
0.0364130279877,
0.0365731314901,
0.0367336699366,
0.0368946440534,
0.037056054569,
0.0372179022147,
0.037380187724,
0.0375429118334,
0.0377060752816,
0.0378696788102,
0.0380337231632,
0.0381982090872,
0.0383631373316,
0.0385285086484,
0.0386943237922,
0.0388605835202,
0.0390272885926,
0.039194439772,
0.0393620378239,
0.0395300835165,
0.0396985776206,
0.0398675209101,
0.0400969755388,
0.0405807184006,
0.0410796846664,
0.0415818738385,
0.0420872977236,
0.0425959681565,
0.0431078970009,
0.0436230961492,
0.0441415775227,
0.0446758288687,
0.0452009627589,
0.0457294149508,
0.0462738302511,
0.0468216931591,
0.0473602780818,
0.0479150208984,
0.0484732488157,
0.0490349744393,
0.0496002104065,
0.0501689693858,
0.0507412640774,
0.0513302183801,
0.0519096765779,
0.0524927089204,
0.0530926013865,
0.0536828748127,
0.0542901429521,
0.0549011460055,
0.0555158973577,
0.0561208644792,
0.0567430977344,
0.0573691195056,
0.0580126546488,
0.058646349467,
0.0592838736149,
0.0599252407193,
0.0605843982969,
0.0612335483267,
0.0619006285297,
0.062557616997,
0.063232676061,
0.0638975587682,
0.0645806532228,
0.0652678150946,
0.0659590587738,
0.0666543986887,
0.0673538493055,
0.0680574251293,
0.0687651407033,
0.069491683685,
0.0702077804355,
0.0709280609484,
0.071667387114,
0.072396137627,
0.0731440802807,
0.0738813605089,
0.0746379801241,
0.0753989904666,
0.0761492074857,
0.0769189862671,
0.0776932019273,
0.0784718699847,
0.0792550060006,
0.0800426255792,
0.0808347443678,
0.0816313780571,
0.0824325423815,
0.0832539911139,
0.0840643246883,
0.0848792365186,
0.0857146627735,
0.0865388399575,
0.0873836859562,
0.0882171931185,
0.0890715242868,
0.0899306535311,
0.0907783085549,
0.0916470219618,
0.0925205833868,
0.0933990096252,
0.0942823175204,
0.0951705239645,
0.0960636458987,
0.0969617003133,
0.0978647042482,
0.0987726747928,
0.099685629087,
0.100603584321,
0.101526557734,
0.102471673744,
0.103404799492,
0.10434299561,
0.105303579293,
0.10625203307,
0.107223038846,
0.108181821134,
0.109163320714,
0.11013250279,
0.111124568314,
0.112121976754,
0.113106925937,
0.11411500952,
0.115128491111,
0.116147389243,
0.117153637658,
0.118183358206,
0.119218551068,
0.120259235006,
0.12130542884,
0.12235715145,
0.123414421773,
0.124477258806,
0.125545681606,
0.126619709291,
0.127699361039,
0.128803481501,
0.129894507483,
0.130991215598,
0.13209362527,
0.133201755984,
0.134334796068,
0.135454496765,
0.136579977513,
0.137730634903,
0.138867804743,
0.140010814224,
0.141179269749,
0.142334088603,
0.143514534358,
0.144681243549,
0.145873761463,
0.147052442496,
0.148257115045,
0.149447849969,
0.15066476018,
0.151887856344,
0.153096863056,
0.154332322652,
0.155553590988,
0.156801498456,
0.158055697962,
0.159295552791,
0.160562328096,
0.161835460002,
0.163094092859,
0.164379929819,
0.165672188617,
0.16697089121,
0.168254887506,
0.16956646973,
0.170884561905,
0.1722091863,
0.173540365263,
0.174856576548,
0.176200856951,
0.177551759263,
0.178909306156,
0.180273520381,
0.181644424775,
0.183000044414,
0.184384321801,
0.185775358176,
0.187173176709,
0.188577800658,
0.189989253366,
0.191385100494,
0.192810203778,
0.194242206182,
0.195681131401,
0.197127003216,
0.198579845502,
0.200039682221,
0.20150653743,
0.20295735358,
0.204438239441,
0.205926216316,
0.207421308634,
0.208923540914,
0.210432937776,
0.211925966132,
0.213449686353,
0.214980645389,
0.216518868247,
0.21806438003,
0.219617205945,
0.22115333028,
0.222720779242,
0.224295618358,
0.225877873241,
0.227467569607,
0.229040284058,
0.23064485871,
0.232256952422,
0.233876591333,
0.235479022252,
0.237113747347,
0.238756096506,
0.240381067042,
0.242038660483,
0.243703957848,
0.24535170509,
0.247032406841,
0.24872089339,
0.250391657462,
0.252095710557,
0.253781925727,
0.255501654498,
0.257203429524,
0.258938944054,
0.260656388646,
0.262407799983,
0.26414102482,
0.265908444995,
0.267657561743,
0.269441103787,
0.271206225116,
0.272979347541,
0.274787242676,
0.276576540385,
0.278373924796,
0.280206432482,
0.282020165235,
0.283842071485,
0.285672180362,
0.287510521129,
0.289384576425,
0.291239559067,
0.293102862449,
0.294974516394,
0.296854550868,
0.298742995983,
0.300639881993,
0.302545239302,
0.30445909846,
0.306381490169,
0.308312445281,
0.3102519948,
0.312171624563,
0.314128364016,
0.316093791584,
0.318067938895,
0.320021920966,
0.322013509838,
0.324013914067,
0.325993968083,
0.328012005856,
0.330009569651,
0.332045370452,
0.334060573223,
0.336114267893,
0.3381472402,
0.340218960962,
0.342269834754,
0.344329661155,
0.346398473439,
0.348506552116,
0.350593533573,
0.352689602078,
0.354794791642,
0.356909136462,
0.359032670927,
0.361165429618,
0.36330744731,
0.365458758976,
0.367619399786,
0.369789405111,
0.3719374842,
0.37412622584,
0.376324439079,
0.378532160114,
0.380717698879,
0.382944444258,
0.385148878928,
0.387394794964,
0.389618271668,
0.391851273865,
0.394126173065,
0.396378439551,
0.398640343275,
0.400944564089,
0.403225958469,
0.405517103918,
0.407818038765,
0.410128801583,
0.412449431188,
0.414779966647,
0.417120447278,
0.419437437995,
0.42179782264,
0.424168271668,
0.426515034032,
0.428905627006,
0.431306405944,
0.433683301321,
0.436070251267,
0.438501621624,
0.440908911149,
0.443326378961,
0.445788715361,
0.448226773634,
0.45067513651,
0.45313384659,
0.455602946779,
0.458082480292,
0.460572490653,
0.463073021703,
0.465548593101,
0.4680701875,
0.470602435746,
0.473109525059,
0.475663105031,
0.478191393262,
0.480766487053,
0.483316156446,
0.485548750958,
0.487209416801,
0.490323607592,
0.493438220841,
0.49623473203,
0.49886305861,
0.501467273016,
0.504117035806,
0.506743318479,
0.509414345995,
0.512062519804,
0.514721749415,
0.517391989233,
0.520073193709,
0.522765317349,
0.525468314705,
0.528182140382,
0.530875944826,
0.533611633877,
0.536327893617,
0.539085259126,
0.541823781494,
0.544602636934,
0.547363229633,
0.550134952389,
0.552917755769,
0.555711590385,
0.558516406893,
0.561332155995,
0.564158788436,
0.566969789567,
0.569818364325,
0.572651852901,
0.575522167429,
0.578377934995,
0.581244922554,
0.584147625505,
0.587036578442,
0.589936592446,
0.592824002807,
0.595746288214,
0.598679473023,
0.601623503933,
0.60455594495,
0.607499732108,
0.610476585308,
0.613442591051,
0.616419770998,
0.619408067372,
0.62240742242,
0.62541777842,
0.628419077223,
0.631451552755,
0.634475433993,
0.637529792138,
0.640576012617,
0.643633453724,
0.646702053115,
0.649781748458,
0.652854757795,
0.655956735972,
0.65906962158,
0.662176461388,
0.665294630032,
0.668424060357,
0.671564685205,
0.67471643742,
0.677879249848,
0.681037777415,
0.684222771838,
0.687403869814,
0.690596277073,
0.693799921409,
0.697014730599,
0.700240632402,
0.70347755456,
0.706712203878,
0.709958227897,
0.713215549136,
0.716484090074,
0.719763773154,
0.723042529753,
0.726344505029,
0.729645876465,
0.732958552067,
0.736282448752,
0.739617483372,
0.742952999435,
0.746299946976,
0.749668352301,
0.753027781275,
0.756408490196,
0.759800274922,
0.763193825596,
0.766598711598,
0.770014837979,
0.773433540132,
0.776863718937,
0.780313418257,
0.783758102121,
0.7872221039,
0.790689654663,
0.794168582321,
0.797658779088,
0.801153219242,
0.804665827636,
0.808182853955,
0.811704770159,
0.815238175299,
0.818782947964,
0.822338966435,
0.825900530956,
0.829473463066,
0.833057633711,
0.836647878478,
0.840244597292,
0.843857544621,
0.847477036329,
0.851103444423,
0.854741301297,
0.858390454676,
0.862046905502,
0.865710982163,
0.86938652552,
0.873073366478,
0.87676811699,
0.880471059071,
0.884182458898,
0.887905339546,
0.891639504764,
0.895379778694,
0.899131493016,
0.902892215725,
0.906662126811,
0.910441387954,
0.914230142021,
0.918028512535,
0.921836603101,
0.925654496795,
0.929480905359,
0.933317441798,
0.937162982979,
0.941018852622,
0.944884074538,
0.948758863923,
0.952642653165,
0.95653646885,
0.960439800014,
0.964352879209,
0.968275052886,
0.972207129628,
0.976148709023,
0.98009973947,
0.984060525308,
0.988030861421,
0.992010835768,
0.996000414264,
0.9999996,
0.9999996,
0.996000414264,
0.992010835768,
0.988030861421,
0.984060525308,
0.98009973947,
0.976148709023,
0.972207129628,
0.968275052886,
0.964352879209,
0.960439800014,
0.95653646885,
0.952642653165,
0.948758863923,
0.944884074538,
0.941018852622,
0.937162982979,
0.933317441798,
0.929480905359,
0.925654496795,
0.921836603101,
0.918028512535,
0.914230142021,
0.910441387954,
0.906662126811,
0.902892215725,
0.899131493016,
0.895379778694,
0.891639504764,
0.887905339546,
0.884182458898,
0.880471059071,
0.87676811699,
0.873073366478,
0.86938652552,
0.865710982163,
0.862046905502,
0.858390454676,
0.854741301297,
0.851103444423,
0.847477036329,
0.843857544621,
0.840244597292,
0.836647878478,
0.833057633711,
0.829473463066,
0.825900530956,
0.822338966435,
0.818782947964,
0.815238175299,
0.811704770159,
0.808182853955,
0.804665827636,
0.801153219242,
0.797658779088,
0.794168582321,
0.790689654663,
0.7872221039,
0.783758102121,
0.780313418257,
0.776863718937,
0.773433540132,
0.770014837979,
0.766598711598,
0.763193825596,
0.759800274922,
0.756408490196,
0.753027781275,
0.749668352301,
0.746299946976,
0.742952999435,
0.739617483372,
0.736282448752,
0.732958552067,
0.729645876465,
0.726344505029,
0.723042529753,
0.719763773154,
0.716484090074,
0.713215549136,
0.709958227897,
0.706712203878,
0.70347755456,
0.700240632402,
0.697014730599,
0.693799921409,
0.690596277073,
0.687403869814,
0.684222771838,
0.681037777415,
0.677879249848,
0.67471643742,
0.671564685205,
0.668424060357,
0.665294630032,
0.662176461388,
0.65906962158,
0.655956735972,
0.652854757795,
0.649781748458,
0.646702053115,
0.643633453724,
0.640576012617,
0.637529792138,
0.634475433993,
0.631451552755,
0.628419077223,
0.62541777842,
0.62240742242,
0.619408067372,
0.616419770998,
0.613442591051,
0.610476585308,
0.607499732108,
0.60455594495,
0.601623503933,
0.598679473023,
0.595746288214,
0.592824002807,
0.589936592446,
0.587036578442,
0.584147625505,
0.581244922554,
0.578377934995,
0.575522167429,
0.572651852901,
0.569818364325,
0.566969789567,
0.564158788436,
0.561332155995,
0.558516406893,
0.555711590385,
0.552917755769,
0.550134952389,
0.547363229633,
0.544602636934,
0.541823781494,
0.539085259126,
0.536327893617,
0.533611633877,
0.530875944826,
0.528182140382,
0.525468314705,
0.522765317349,
0.520073193709,
0.517391989233,
0.514721749415,
0.512062519804,
0.509414345995,
0.506743318479,
0.504117035806,
0.501467273016,
0.49886305861,
0.49623473203,
0.493438220841,
0.490323607592,
0.487209416801,
0.485548750958,
0.483316156446,
0.480766487053,
0.478191393262,
0.475663105031,
0.473109525059,
0.470602435746,
0.4680701875,
0.465548593101,
0.463073021703,
0.460572490653,
0.458082480292,
0.455602946779,
0.45313384659,
0.45067513651,
0.448226773634,
0.445788715361,
0.443326378961,
0.440908911149,
0.438501621624,
0.436070251267,
0.433683301321,
0.431306405944,
0.428905627006,
0.426515034032,
0.424168271668,
0.42179782264,
0.419437437995,
0.417120447278,
0.414779966647,
0.412449431188,
0.410128801583,
0.407818038765,
0.405517103918,
0.403225958469,
0.400944564089,
0.398640343275,
0.396378439551,
0.394126173065,
0.391851273865,
0.389618271668,
0.387394794964,
0.385148878928,
0.382944444258,
0.380717698879,
0.378532160114,
0.376324439079,
0.37412622584,
0.3719374842,
0.369789405111,
0.367619399786,
0.365458758976,
0.36330744731,
0.361165429618,
0.359032670927,
0.356909136462,
0.354794791642,
0.352689602078,
0.350593533573,
0.348506552116,
0.346398473439,
0.344329661155,
0.342269834754,
0.340218960962,
0.3381472402,
0.336114267893,
0.334060573223,
0.332045370452,
0.330009569651,
0.328012005856,
0.325993968083,
0.324013914067,
0.322013509838,
0.320021920966,
0.318067938895,
0.316093791584,
0.314128364016,
0.312171624563,
0.3102519948,
0.308312445281,
0.306381490169,
0.30445909846,
0.302545239302,
0.300639881993,
0.298742995983,
0.296854550868,
0.294974516394,
0.293102862449,
0.291239559067,
0.289384576425,
0.287510521129,
0.285672180362,
0.283842071485,
0.282020165235,
0.280206432482,
0.278373924796,
0.276576540385,
0.274787242676,
0.272979347541,
0.271206225116,
0.269441103787,
0.267657561743,
0.265908444995,
0.26414102482,
0.262407799983,
0.260656388646,
0.258938944054,
0.257203429524,
0.255501654498,
0.253781925727,
0.252095710557,
0.250391657462,
0.24872089339,
0.247032406841,
0.24535170509,
0.243703957848,
0.242038660483,
0.240381067042,
0.238756096506,
0.237113747347,
0.235479022252,
0.233876591333,
0.232256952422,
0.23064485871,
0.229040284058,
0.227467569607,
0.225877873241,
0.224295618358,
0.222720779242,
0.22115333028,
0.219617205945,
0.21806438003,
0.216518868247,
0.214980645389,
0.213449686353,
0.211925966132,
0.210432937776,
0.208923540914,
0.207421308634,
0.205926216316,
0.204438239441,
0.20295735358,
0.20150653743,
0.200039682221,
0.198579845502,
0.197127003216,
0.195681131401,
0.194242206182,
0.192810203778,
0.191385100494,
0.189989253366,
0.188577800658,
0.187173176709,
0.185775358176,
0.184384321801,
0.183000044414,
0.181644424775,
0.180273520381,
0.178909306156,
0.177551759263,
0.176200856951,
0.174856576548,
0.173540365263,
0.1722091863,
0.170884561905,
0.16956646973,
0.168254887506,
0.16697089121,
0.165672188617,
0.164379929819,
0.163094092859,
0.161835460002,
0.160562328096,
0.159295552791,
0.158055697962,
0.156801498456,
0.155553590988,
0.154332322652,
0.153096863056,
0.151887856344,
0.15066476018,
0.149447849969,
0.148257115045,
0.147052442496,
0.145873761463,
0.144681243549,
0.143514534358,
0.142334088603,
0.141179269749,
0.140010814224,
0.138867804743,
0.137730634903,
0.136579977513,
0.135454496765,
0.134334796068,
0.133201755984,
0.13209362527,
0.130991215598,
0.129894507483,
0.128803481501,
0.127699361039,
0.126619709291,
0.125545681606,
0.124477258806,
0.123414421773,
0.12235715145,
0.12130542884,
0.120259235006,
0.119218551068,
0.118183358206,
0.117153637658,
0.116147389243,
0.115128491111,
0.11411500952,
0.113106925937,
0.112121976754,
0.111124568314,
0.11013250279,
0.109163320714,
0.108181821134,
0.107223038846,
0.10625203307,
0.105303579293,
0.10434299561,
0.103404799492,
0.102471673744,
0.101526557734,
0.100603584321,
0.099685629087,
0.0987726747928,
0.0978647042482,
0.0969617003133,
0.0960636458987,
0.0951705239645,
0.0942823175204,
0.0933990096252,
0.0925205833868,
0.0916470219618,
0.0907783085549,
0.0899306535311,
0.0890715242868,
0.0882171931185,
0.0873836859562,
0.0865388399575,
0.0857146627735,
0.0848792365186,
0.0840643246883,
0.0832539911139,
0.0824325423815,
0.0816313780571,
0.0808347443678,
0.0800426255792,
0.0792550060006,
0.0784718699847,
0.0776932019273,
0.0769189862671,
0.0761492074857,
0.0753989904666,
0.0746379801241,
0.0738813605089,
0.0731440802807,
0.072396137627,
0.071667387114,
0.0709280609484,
0.0702077804355,
0.069491683685,
0.0687651407033,
0.0680574251293,
0.0673538493055,
0.0666543986887,
0.0659590587738,
0.0652678150946,
0.0645806532228,
0.0638975587682,
0.063232676061,
0.062557616997,
0.0619006285297,
0.0612335483267,
0.0605843982969,
0.0599252407193,
0.0592838736149,
0.058646349467,
0.0580126546488,
0.0573691195056,
0.0567430977344,
0.0561208644792,
0.0555158973577,
0.0549011460055,
0.0542901429521,
0.0536828748127,
0.0530926013865,
0.0524927089204,
0.0519096765779,
0.0513302183801,
0.0507412640774,
0.0501689693858,
0.0496002104065,
0.0490349744393,
0.0484732488157,
0.0479150208984,
0.0473602780818,
0.0468216931591,
0.0462738302511,
0.0457294149508,
0.0452009627589,
0.0446758288687,
0.0441415775227,
0.0436230961492,
0.0431078970009,
0.0425959681565,
0.0420872977236,
0.0415818738385,
0.0410796846664,
0.0405807184006,
0.0400969755388,
0.0398675209101,
0.0396985776206,
0.0395300835165,
0.0393620378239,
0.039194439772,
0.0390272885926,
0.0388605835202,
0.0386943237922,
0.0385285086484,
0.0383631373316,
0.0381982090872,
0.0380337231632,
0.0378696788102,
0.0377060752816,
0.0375429118334,
0.037380187724,
0.0372179022147,
0.037056054569,
0.0368946440534,
0.0367336699366,
0.0365731314901,
0.0364130279877,
0.0362533587058,
0.0360941229233,
0.0359353199217,
0.0357769489848,
0.0356190093989,
0.0354615004527,
0.0353044214375,
0.0351477716469,
0.0349915503768,
0.0348357569258,
0.0346803905945,
0.0345254506862,
0.0343709365063,
0.0342168473628,
0.0340631825657,
0.0339099414276,
0.0337571232634,
0.0336047273901,
0.033452753127,
0.033301199796,
0.0331500667208,
0.0329993532277,
0.032849058645,
0.0326991823034,
0.0325497235357,
0.032400681677,
0.0322520560644,
0.0321038460375,
0.0319560509377,
0.0318086701088,
0.0316617028968,
0.0315151486495,
0.0313690067172,
0.0312232764521,
0.0310779572085,
0.030933048343,
0.030788549214,
0.0306444591821,
0.0305007776101,
0.0303575038625,
0.0302146373063,
0.0300721773102,
0.0299301232449,
0.0297884744833,
0.0296472304002,
0.0295063903725,
0.0293659537789,
0.0292259200001,
0.029086288419,
0.0289470584201,
0.0288082293902,
0.0286698007177,
0.0285317717931,
0.0283941420088,
0.0282569107591,
0.0281200774402,
0.0279836414501,
0.0278476021889,
0.0277119590583,
0.027576711462,
0.0274418588055,
0.0273074004963,
0.0271733359435,
0.0270396645581,
0.026906385753,
0.0267734989428,
0.0266410035441,
0.0265088989749,
0.0263771846553,
0.0262458600072,
0.026114924454,
0.0259843774212,
0.0258542183356,
0.0257244466262,
0.0255950617234,
0.0254660630596,
0.0253374500686,
0.0252092221861,
0.0250813788496,
0.024953919498,
0.0248268435721,
0.0247001505144,
0.0245738397689,
0.0244479107813,
0.0243223629992,
0.0241971958714,
0.0240724088487,
0.0239480013834,
0.0238239729295,
0.0237003229424,
0.0235770508794,
0.0234541561991,
0.023331638362,
0.02320949683,
0.0230877310665,
0.0229663405367,
0.0228453247072,
0.0227246830462,
0.0226044150235,
0.0224845201103,
0.0223649977795,
0.0222458475055,
0.0221270687641,
0.0220086610327,
0.0218906237903,
0.0217729565172,
0.0216556586954,
0.0215387298082,
0.0214221693406,
0.0213059767788,
0.0211901516107,
0.0210746933256,
0.0209596014142,
0.0208448753687,
0.0207305146827,
0.0206165188514,
0.0205028873711,
0.0203896197399,
0.020276715457,
0.0201641740232,
0.0200519949408,
0.0199401777131,
0.0198287218453,
0.0197176268435,
0.0196068922157,
0.0194965174708,
0.0193865021192,
0.019276845673,
0.0191675476452,
0.0190586075503,
0.0189500249043,
0.0188417992245,
0.0187339300292,
0.0186264168386,
0.0185192591736,
0.018412456557,
0.0183060085126,
0.0181999145654,
0.018094174242,
0.0179887870701,
0.0178837525787,
0.0177790702982,
0.0176747397601,
0.0175707604975,
0.0174671320443,
0.017363853936,
0.0172609257093,
0.017158346902,
0.0170561170535,
0.016954235704,
0.0168527023953,
0.0167515166701,
0.0166506780727,
0.0165501861483,
0.0164500404435,
0.016350240506,
0.0162507858849,
0.0161516761303,
0.0160529107934,
0.015954489427,
0.0158564115848,
0.0157586768216,
0.0156612846936,
0.015564234758,
0.0154675265734,
0.0153711596992,
0.0152751336963,
0.0151794481266,
0.0150841025532,
0.0149890965402,
0.014894429653,
0.0148001014582,
0.0147061115233,
0.0146124594171,
0.0145191447094,
0.0144261669713,
0.0143335257748,
0.0142412206931,
0.0141492513006,
0.0140576171726,
0.0139663178857,
0.0138753530174,
0.0137847221465,
0.0136944248526,
0.0136044607167,
0.0135148293206,
0.0134255302474,
0.013336563081,
0.0132479274066,
0.0131596228104,
0.0130716488796,
0.0129840052024,
0.0128966913681,
0.0128097069672,
0.0127230515909,
0.0126367248318,
0.0125507262833,
0.0124650555397,
0.0123797121967,
0.0122946958508,
0.0122100060994,
0.0121256425411,
0.0120416047754,
0.0119578924029,
0.0118745050251,
0.0117914422445,
0.0117087036646,
0.01162628889,
0.0115441975261,
0.0114624291794,
0.0113809834573,
0.0112998599682,
0.0112190583215,
0.0111385781276,
0.0110584189976,
0.0109785805439,
0.0108990623797,
0.0108198641191,
0.0107409853772,
0.0106624257701,
0.0105841849147,
0.010506262429,
0.0104286579317,
0.0103513710427,
0.0102744013826,
0.0101977485731,
0.0101214122367,
0.0100453919967,
0.0099696874777,
0.0098942983048,
0.00981922410421,
0.00974446450298,
0.00967001912909,
0.00959588761137,
0.00952206957959,
0.00944856466437,
0.00937537249722,
0.00930249271054,
0.00922992493761,
0.00915766881257,
0.00908572397044,
0.0090140900471,
0.0089427666793,
0.00887175350466,
0.00880105016165,
0.00873065628958,
0.00866057152863,
0.00859079551984,
0.00852132790506,
0.00845216832702,
0.00838331642926,
0.00831477185618,
0.00824653425299,
0.00817860326576,
0.00811097854136,
0.0080436597275,
0.0079766464727,
0.00790993842631,
0.0078435352385,
0.00777743656024,
0.00771164204332,
0.00764615134031,
0.00758096410463,
0.00751607999047,
0.00745149865283,
0.00738721974749,
0.00732324293104,
0.00725956786086,
0.0071961941951,
0.00713312159272,
0.00707034971344,
0.00700787821777,
0.006945706767,
0.00688383502317,
0.00682226264911,
0.00676098930843,
0.00670001466548,
0.00663933838539,
0.00657896013404,
0.00651887957807,
0.00645909638487,
0.00639961022261,
0.00634042076016,
0.00628152766719,
0.00622293061407,
0.00616462927194,
0.00610662331267,
0.00604891240886,
0.00599149623386,
0.00593437446174,
0.00587754676729,
0.00582101282606,
0.00576477231429,
0.00570882490895,
0.00565317028774,
0.00559780812907,
0.00554273811206,
0.00548795991655,
0.00543347322308,
0.00537927771291,
0.00532537306799,
0.00527175897098,
0.00521843510525,
0.00516540115484,
0.00511265680451,
0.00506020173971,
0.00500803564656,
0.0049561582119,
0.00490456912322,
0.00485326806873,
0.00480225473729,
0.00475152881846,
0.00470109000246,
0.00465093798021,
0.00460107244327,
0.00455149308389,
0.00450219959498,
0.00445319167012,
0.00440446900356,
0.00435603129019,
0.00430787822558,
0.00426000950595,
0.00421242482816,
0.00416512388974,
0.00411810638887,
0.00407137202437,
0.00402492049571,
0.003978751503,
0.003932864747,
0.00388725992909,
0.00384193675132,
0.00379689491634,
0.00375213412746,
0.00370765408861,
0.00366345450435,
0.00361953507986,
0.00357589552096,
0.00353253553408,
0.00348945482629,
0.00344665310525,
0.00340413007926,
0.00336188545722,
0.00331991894866,
0.00327823026371,
0.00323681911311,
0.0031956852082,
0.00315482826094,
0.00311424798389,
0.0030739440902,
0.00303391629363,
0.00299416430853,
0.00295468784985,
0.00291548663314,
0.00287656037453,
0.00283790879075,
0.00279953159911,
0.0027614285175,
0.00272359926442,
0.00268604355892,
0.00264876112066,
0.00261175166985,
0.0025750149273,
0.00253855061438,
0.00250235845305,
0.00246643816583,
0.0024307894758,
0.00239541210663,
0.00236030578255,
0.00232547022833,
0.00229090516933,
0.00225661033147,
0.00222258544121,
0.00218883022558,
0.00215534441218,
0.00212212772913,
0.00208917990512,
0.0020565006694,
0.00202408975176,
0.00199194688252,
0.00196007179258,
0.00192846421335,
0.00189712387681,
0.00186605051546,
0.00183524386234,
0.00180470365103,
0.00177442961566,
0.00174442149087,
0.00171467901186,
0.00168520191432,
0.0016559899345,
0.00162704280917,
0.00159836027563,
0.00156994207169,
0.0015417879357,
0.00151389760651,
0.0014862708235,
0.00145890732657,
0.00143180685614,
0.00140496915313,
0.00137839395899,
0.00135208101566,
0.0013260300656,
0.00130024085179,
0.00127471311771,
0.00124944660732,
0.00122444106512,
0.0011996962361,
0.00117521186574,
0.00115098770003,
0.00112702348545,
0.00110331896898,
0.0010798738981,
0.00105668802078,
0.00103376108546,
0.00101109284111,
0.000988683037166,
0.000966531423544,
0.000944637750659,
0.000923001769408,
0.000901623231167,
0.000880501887798,
0.000859637491639,
0.000839029795509,
0.000818678552704,
0.000798583516995,
0.000778744442628,
0.000759161084321,
0.000739833197266,
0.000720760537122,
0.00070194286002,
0.000683379922555,
0.000665071481792,
0.000647017295258,
0.000629217120943,
0.000611670717302,
0.000594377843247,
0.000577338258152,
0.000560551721848,
0.000544017994622,
0.000527736837218,
0.000511708010833,
0.000495931277117,
0.00048040639817,
0.000465133136543,
0.000450111255237,
0.0004353405177,
0.000420820687823,
0.000406551529947,
0.000392532808853,
0.000378764289766,
0.00036524573835,
0.000351976920712,
0.000338957603395,
0.00032618755338,
0.000313666538084,
0.000301394325359,
0.000289370683491,
0.000277595381197,
0.000266068187626,
0.000254788872356,
0.000243757205395,
0.000232972957178,
0.000222435898565,
0.000212145800842,
0.000202102435719,
0.000192305575327,
0.000182754992221,
0.000173450459374,
0.000164391750178,
0.000155578638445,
0.000147010898401,
0.000138688304689,
0.000130610632366,
0.000122777656902,
0.000115189154179,
0.00010784490049,
0.000100744672538,
9.38882474334e-05,
8.72754026948e-05,
8.0905916247e-05,
7.47795664199e-05,
6.88961319473e-05,
6.3255391966e-05,
5.78571260143e-05,
5.27011140313e-05,
4.77871363556e-05,
4.31149737242e-05,
3.86844072715e-05,
3.44952185279e-05,
3.0547189419e-05,
2.68401022646e-05,
2.33737397771e-05,
2.0147885061e-05,
1.71623216114e-05,
1.44168333134e-05,
1.19112044403e-05,
9.64521965335e-06,
7.618664e-06,
5.83132291331e-06,
4.28298221065e-06,
2.97342809275e-06,
1.9024471426e-06,
1.06982632445e-06,
4.75352982743e-07,
1.18814841075e-07,
1.1851852203e-15]

# Creation de la figure
fig, ax = plt.subplots()
plt.subplots_adjust(left=0.15, bottom=0.25)

# On trace la courbe spinodale
plt.plot(v_spin,p_spin,'k--',lw=2)

# On trace la courbe de saturation
plt.plot(v_sat,p_sat,'b--',lw=2)

# Limites
Vr_min=0.4
Vr_max=3.0
Pr_min=0.0
Pr_max=2.5

# Creation de l'axe des abscisses, ici le volume 
# On utilise le meme que pour la courbe de saturation, pour simplifier la recherche des points de croisement
Vr=np.array(v_sat)

# Parametres de la fonction, avec des valeurs par defaut
T0 = 0.9
Tr=T0

# Equation de van der Waals en variables reduites
def VdW_Pr(Tr,Vr):
    return((8.0*Tr/(3.0*Vr-1.0))-3/np.power(Vr,2.0))

# Creation de la fonction a tracer 
Pr = VdW_Pr(Tr,Vr)

# Creation de la trace de la fonction Pr en fonction de Vr. C'est un objet qui est sauvegarde dans 'l'
l, = plt.plot(Vr,Pr, lw=4, color='red')

plt.legend(["Courbe spinodale","Courbe de saturation","Isotherme"])

# Fonction de calcul de la spinodale
def spinodale(Tr):
    local_v_spin=[]
    local_p_spin=[]
    # On calcule la position des zeros de la derivee de p par rapport a v (tangentes horizontales)
    null_dpdv=np.roots([4.0*Tr,-9.0,6.0,-1.0])
    # On ne garde que les valeurs v>1/3, etant donnee que c'est une limite inferieure pour le volume reduit
    null_dpdv=null_dpdv[np.where(null_dpdv>1./3.)]
    # On calcule la pression correspondant a chacun de ces points, et si elle est positive, on trace le point dans le plan (Vr,Pr)
    for v in null_dpdv:
        p=VdW_Pr(Tr,v)
        if (p>0.0):
            local_v_spin.append(v)
            local_p_spin.append(p)
    return(local_v_spin,local_p_spin)

# Fonction de calcul de la courbe de saturation
# Pour calculer la courbe de saturation, on suit la construction de Maxwell
# On explore un domaine de pression "raisonnable" entre les deux pressions correspondant aux tangentes horizontales
def saturation(Tr):
    # On calcule la pression reduite
    Pr=VdW_Pr(Tr,Vr)
    # On determine le domaine ou cette pression est inferieure a la pression de la courbe de saturation
    # On prendra garde, avant d'appeler cette fonction, a verifier que Tr<1
    w=np.where(Pr<np.array(p_sat))
    # On en tire les valeurs extremes, qui sont donc les volumes reduits correspondant aux croisements de l'isotherme avec la courbe de saturation
    V0=Vr[w[0][0]]
    V1=Vr[w[0][len(w[0])-1]]
    # On calcule les pressions correspondantes
    P0=VdW_Pr(Tr,V0)
    P1=VdW_Pr(Tr,V1)
    return([V0,V1],[P0,P1])

# Calcul et affichage du point courant sur la courbe spinodale
local_v_spin,local_p_spin=spinodale(Tr)
lspin,=plt.plot(local_v_spin,local_p_spin,'ko')

# Calcul et affichage du point courant sur la courbe de saturation
local_v_sat,local_p_sat=saturation(Tr)
lsat,=plt.plot(local_v_sat,local_p_sat,'bo',ls='-',lw=4)

# Specification des limites des axes (xmin,xmax,ymin,ymax)
plt.axis([Vr_min,Vr_max,Pr_min,Pr_max])

# Affichage du point critique
plt.plot(1.0,1.0,'go')

# Affichage des axes
plt.xlabel(r"Volume reduit $V_r$",fontsize=20)
plt.ylabel(r"Pression reduite $P_r$"+"\n",fontsize=20)
plt.title('Transition liquide-vapeur pour un fluide de Van der Waals')
for tick in ax.xaxis.get_major_ticks():tick.label.set_fontsize(15) 
for tick in ax.yaxis.get_major_ticks():tick.label.set_fontsize(15) 

# Creation des barres de modification amplitude et frequence
axcolor = 'lightgoldenrodyellow'
axT = plt.axes([0.25, 0.07, 0.65, 0.03], facecolor=axcolor)
sT = Slider(axT, 'Temperature reduite $T_r$', 0.85,1.15, valinit=T0) # Remarquer la valeur initiale f0

# Fonction de mise a jour du graphique
def update(val):
    Tr = sT.val # On recupere la valeur de la barre sfreq comme frequence
    Pr=VdW_Pr(Tr,Vr)
    l.set_ydata(Pr) # On met a jour l'objet 'l' avec ces nouvelles valeurs 
    if(Tr<1.0):
        local_v_spin,local_p_spin=spinodale(Tr)
        lspin.set_xdata(local_v_spin)
        lspin.set_ydata(local_p_spin)
        local_v_sat,local_p_sat=saturation(Tr)
        lsat.set_xdata(local_v_sat)
        lsat.set_ydata(local_p_sat)
        lspin.set_visible(True)
        lsat.set_visible(True)
    else:
        lspin.set_visible(False)
        lsat.set_visible(False)

sT.on_changed(update) # lorsque la barre sT est modifiee, on applique la fonction update

# Creation du bouton de "reset"
resetax = plt.axes([0.8, 0.015, 0.1, 0.04]) 
button = Button(resetax, 'Reset', color=axcolor, hovercolor='0.975')
# Definition de la fonction de "reset" (valeurs par defaut)
def reset(event):
    sT.reset() # La methode .reset() appliquee a la barre sT lui redonne sa valeur valinit, soit T0
button.on_clicked(reset) # Lorsqu'on clique sur "reset", on applique la fonction reset definie au dessus

plt.show() # On provoque l'affichage a l'ecran
